USE [BDApp];

SET ANSI_NULLS ON;

SET QUOTED_IDENTIFIER ON;

CREATE TABLE [dbo].[client](
	[id] [bigint] IDENTITY(1,1) NOT NULL,
	[created_by] [varchar](255) NULL,
	[created_on] [datetime] NULL,
	[updated_by] [varchar](255) NULL,
	[updated_on] [datetime] NULL,
	[city] [varchar](255) NULL,
	[cliente_id] [varchar](255) NULL,
	[fiscal_name] [varchar](255) NULL,
	[office] [varchar](255) NULL,
	[rfc] [varchar](255) NULL,
	[trade_name] [varchar](255) NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY];

SET ANSI_NULLS ON;

SET QUOTED_IDENTIFIER ON;

CREATE TABLE [dbo].[files](
	[id] [bigint] IDENTITY(1,1) NOT NULL,
	[created_by] [varchar](255) NULL,
	[created_on] [datetime] NULL,
	[updated_by] [varchar](255) NULL,
	[updated_on] [datetime] NULL,
	[data] [varbinary](max) NULL,
	[file_name] [varchar](255) NULL,
	[file_type] [varchar](255) NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

SET ANSI_NULLS ON;

SET QUOTED_IDENTIFIER ON;

CREATE TABLE [dbo].[giftcard](
	[id] [bigint] IDENTITY(1,1) NOT NULL,
	[created_by] [varchar](255) NULL,
	[created_on] [datetime] NULL,
	[updated_by] [varchar](255) NULL,
	[updated_on] [datetime] NULL,
	[balance] [float] NULL,
	[create_date] [datetime] NULL,
	[user_id] [bigint] NOT NULL,
	[card_number] [varchar](255) NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY];

SET ANSI_NULLS ON;

SET QUOTED_IDENTIFIER ON;

CREATE TABLE [dbo].[giftcard_transaction](
	[amount] [float] NULL,
	[client_id] [bigint] NULL,
	[giftcard_id] [bigint] NULL,
	[giftcard_number] [varchar](255) NULL,
	[paypal_transaction_id] [varchar](255) NULL,
	[transaction_type] [int] NULL,
	[created_by] [varchar](255) NULL,
	[created_on] [datetime] NULL,
	[updated_by] [varchar](255) NULL,
	[updated_on] [datetime] NULL,
	[id] [bigint] IDENTITY(1,1) NOT NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY];

SET ANSI_NULLS ON;

SET QUOTED_IDENTIFIER ON;

CREATE TABLE [dbo].[rewards_card](
	[create_date] [datetime] NULL,
	[point_balance] [float] NULL,
	[user_id] [bigint] NOT NULL,
	[id] [bigint] IDENTITY(1,1) NOT NULL,
	[created_by] [varchar](255) NULL,
	[created_on] [datetime] NULL,
	[updated_by] [varchar](255) NULL,
	[updated_on] [datetime] NULL,
	[card_number] [varchar](255) NULL,
	[owner_dup] [varbinary](255) NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY];

SET ANSI_NULLS ON;

SET QUOTED_IDENTIFIER ON;

CREATE TABLE [dbo].[state](
	[id] [bigint] IDENTITY(1,1) NOT NULL,
	[created_by] [varchar](255) NULL,
	[created_on] [datetime] NULL,
	[updated_by] [varchar](255) NULL,
	[updated_on] [datetime] NULL,
	[entity] [varchar](255) NULL,
	[name] [varchar](255) NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY];

SET ANSI_NULLS ON;

SET QUOTED_IDENTIFIER ON;

CREATE TABLE [dbo].[system_parameter](
	[id] [bigint] IDENTITY(1,1) NOT NULL,
	[created_by] [varchar](255) NULL,
	[created_on] [datetime] NULL,
	[updated_by] [varchar](255) NULL,
	[updated_on] [datetime] NULL,
	[optional_value] [varchar](255) NULL,
	[property_key] [varchar](255) NULL,
	[value] [varchar](255) NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY];

SET ANSI_NULLS ON;

SET QUOTED_IDENTIFIER ON;

CREATE TABLE [dbo].[users](
	[id] [bigint] IDENTITY(1,1) NOT NULL,
	[created_by] [varchar](255) NULL,
	[created_on] [datetime] NULL,
	[updated_by] [varchar](255) NULL,
	[updated_on] [datetime] NULL,
	[email] [varchar](255) NOT NULL,
	[email_verified] [bit] NOT NULL,
	[enabled] [bit] NOT NULL,
	[last_access] [datetime] NULL,
	[last_name] [varchar](255) NULL,
	[name] [varchar](255) NOT NULL,
	[password] [varchar](255) NULL,
	[phone] [varchar](255) NULL,
	[register_date] [datetime] NULL,
	[device_id] [varchar](255) NULL,
	[device_type] [varchar](255) NULL,
	[provider] [varchar](255) NOT NULL,
	[provider_id] [varchar](255) NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY];

SET ANSI_NULLS ON;

SET QUOTED_IDENTIFIER ON;

CREATE TABLE [dbo].[verification_number](
	[id] [bigint] IDENTITY(1,1) NOT NULL,
	[created_by] [varchar](255) NULL,
	[created_on] [datetime] NULL,
	[updated_by] [varchar](255) NULL,
	[updated_on] [datetime] NULL,
	[code] [int] NOT NULL,
	[date] [datetime] NULL,
	[phone] [varchar](255) NULL,
PRIMARY KEY CLUSTERED
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY];

SET IDENTITY_INSERT [dbo].[users] ON

INSERT [dbo].[users] ([id], [created_by], [created_on], [updated_by], [updated_on], [email], [email_verified], [enabled], [last_access], [last_name], [name], [password], [phone], [register_date], [device_id], [device_type], [provider], [provider_id]) VALUES (1, 'admin', CAST(N'2020-01-01T12:00:00.000' AS DateTime), 'admin', CAST(N'2020-01-01T12:00:00.000' AS DateTime), N'admin@sierra.com.mx', 1, 1, CAST(N'2020-01-01T12:00:00.000' AS DateTime), N'Sistemas Sierra', N'Administrador', N'$2a$10$Jvb/JkoHQQKUtXwNHw5eVuLNBdDeWUJxUih/QtLlpmJhob/ghHrnS', N'6865663420', CAST(N'2020-01-01T12:00:00.000' AS DateTime), N'1', N'1', N'local', N'1')
SET IDENTITY_INSERT [dbo].[users] OFF;

SET ANSI_PADDING ON;

ALTER TABLE [dbo].[users] ADD  CONSTRAINT [UK6dotkott2kjsp8vw4d0m25fb7] UNIQUE NONCLUSTERED
(
	[email] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY];

ALTER TABLE [dbo].[giftcard]  WITH CHECK ADD  CONSTRAINT [FK28tr0y4yqfepm6wob0ew841jw] FOREIGN KEY([user_id])
REFERENCES [dbo].[users] ([id]);

ALTER TABLE [dbo].[giftcard] CHECK CONSTRAINT [FK28tr0y4yqfepm6wob0ew841jw];

ALTER TABLE [dbo].[rewards_card]  WITH CHECK ADD  CONSTRAINT [FKjblkcsuo5wcot205thp0m7env] FOREIGN KEY([user_id])
REFERENCES [dbo].[users] ([id]);

ALTER TABLE [dbo].[rewards_card] CHECK CONSTRAINT [FKjblkcsuo5wcot205thp0m7env];

USE [master];

ALTER DATABASE [BDApp] SET  READ_WRITE;