/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.ultima.view.dnd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ManagedProperty;
import javax.faces.bean.ViewScoped;
import javax.faces.context.FacesContext;
import org.primefaces.model.DefaultTreeNode;
import org.primefaces.model.TreeNode;
import org.primefaces.ultima.domain.Car;
import org.primefaces.ultima.service.CarService;
import org.primefaces.ultima.view.dnd.ColumnManagerView;

@ManagedBean
@ViewScoped
public class ColumnManagerView
implements Serializable {
    private final List<String> VALID_COLUMN_KEYS = Arrays.asList("id", "brand", "year", "color");
    private List<ColumnModel> columns = new ArrayList();
    private List<Car> cars;
    private TreeNode availableColumns;
    @ManagedProperty(value="#{carService}")
    private CarService service;

    @PostConstruct
    public void init() {
        this.cars = this.service.createCars(9);
        this.createAvailableColumns();
        this.createDynamicColumns();
    }

    private void createAvailableColumns() {
        this.availableColumns = new DefaultTreeNode((Object)"Root", null);
        DefaultTreeNode root = new DefaultTreeNode((Object)"Columns", this.availableColumns);
        root.setExpanded(true);
        DefaultTreeNode model = new DefaultTreeNode("column", (Object)new ColumnModel("Id", "id"), (TreeNode)root);
        DefaultTreeNode year = new DefaultTreeNode("column", (Object)new ColumnModel("Year", "year"), (TreeNode)root);
        DefaultTreeNode manufacturer = new DefaultTreeNode("column", (Object)new ColumnModel("Brand", "brand"), (TreeNode)root);
        DefaultTreeNode color = new DefaultTreeNode("column", (Object)new ColumnModel("Color", "color"), (TreeNode)root);
    }

    public void createDynamicColumns() {
        String[] columnKeys = new String[]{"id", "year", "brand"};
        this.columns.clear();
        for (String columnKey : columnKeys) {
            String key = columnKey.trim();
            if (!this.VALID_COLUMN_KEYS.contains(key)) continue;
            this.columns.add(new ColumnModel(columnKey.toUpperCase(), columnKey));
        }
    }

    public void treeToTable() {
        Map params = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap();
        String property = (String)params.get("property");
        String droppedColumnId = (String)params.get("droppedColumnId");
        String dropPos = (String)params.get("dropPos");
        String[] droppedColumnTokens = droppedColumnId.split(":");
        int draggedColumnIndex = Integer.parseInt(droppedColumnTokens[droppedColumnTokens.length - 1]);
        int dropColumnIndex = draggedColumnIndex + Integer.parseInt(dropPos);
        this.columns.add(dropColumnIndex, new ColumnModel(property.toUpperCase(), property));
        TreeNode root = (TreeNode)this.availableColumns.getChildren().get(0);
        for (TreeNode node : root.getChildren()) {
            ColumnModel model = (ColumnModel)node.getData();
            if (!model.getProperty().equals(property)) continue;
            root.getChildren().remove(node);
            break;
        }
    }

    public void tableToTree() {
        Map params = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap();
        int colIndex = Integer.parseInt((String)params.get("colIndex"));
        ColumnModel model = (ColumnModel)this.columns.remove(colIndex);
        DefaultTreeNode property = new DefaultTreeNode("column", (Object)model, (TreeNode)this.availableColumns.getChildren().get(0));
    }

    public List<Car> getCars() {
        return this.cars;
    }

    public List<ColumnModel> getColumns() {
        return this.columns;
    }

    public TreeNode getAvailableColumns() {
        return this.availableColumns;
    }

    public void setService(CarService service) {
        this.service = service;
    }
}

