/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.ultima.view.data.treetable;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ManagedProperty;
import javax.faces.bean.ViewScoped;
import org.primefaces.model.TreeNode;
import org.primefaces.ultima.service.DocumentService;
import org.primefaces.ultima.view.data.treetable.ColumnsView;

@ManagedBean(name="ttColumnsView")
@ViewScoped
public class ColumnsView
implements Serializable {
    private static final List<String> VALID_COLUMN_KEYS = Arrays.asList("name", "size", "type");
    private String columnTemplate = "name size type";
    private List<ColumnModel> columns;
    private TreeNode root;
    @ManagedProperty(value="#{documentService}")
    private DocumentService service;

    @PostConstruct
    public void init() {
        this.root = this.service.createDocuments();
        this.createDynamicColumns();
    }

    public TreeNode getRoot() {
        return this.root;
    }

    public void setService(DocumentService service) {
        this.service = service;
    }

    public void createDynamicColumns() {
        String[] columnKeys = this.columnTemplate.split(" ");
        this.columns = new ArrayList();
        for (String columnKey : columnKeys) {
            String key = columnKey.trim();
            if (!VALID_COLUMN_KEYS.contains(key)) continue;
            this.columns.add(new ColumnModel(columnKey.toUpperCase(), columnKey));
        }
    }

    public String getColumnTemplate() {
        return this.columnTemplate;
    }

    public void setColumnTemplate(String columnTemplate) {
        this.columnTemplate = columnTemplate;
    }

    public List<ColumnModel> getColumns() {
        return this.columns;
    }
}

