/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.ultima.view.data.tree;

import java.io.Serializable;
import javax.annotation.PostConstruct;
import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ManagedProperty;
import javax.faces.bean.ViewScoped;
import javax.faces.context.FacesContext;
import org.primefaces.model.TreeNode;
import org.primefaces.ultima.service.DocumentService;

@ManagedBean(name="treeContextMenuView")
@ViewScoped
public class ContextMenuView
implements Serializable {
    private TreeNode root;
    private TreeNode selectedNode;
    @ManagedProperty(value="#{documentService}")
    private DocumentService service;

    @PostConstruct
    public void init() {
        this.root = this.service.createDocuments();
    }

    public TreeNode getRoot() {
        return this.root;
    }

    public TreeNode getSelectedNode() {
        return this.selectedNode;
    }

    public void setSelectedNode(TreeNode selectedNode) {
        this.selectedNode = selectedNode;
    }

    public void setService(DocumentService service) {
        this.service = service;
    }

    public void displaySelectedSingle() {
        if (this.selectedNode != null) {
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_INFO, "Selected", this.selectedNode.getData().toString());
            FacesContext.getCurrentInstance().addMessage(null, message);
        }
    }

    public void deleteNode() {
        this.selectedNode.getChildren().clear();
        this.selectedNode.getParent().getChildren().remove(this.selectedNode);
        this.selectedNode.setParent(null);
        this.selectedNode = null;
    }
}

