/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.ultima.view.data.datatable;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ViewScoped;
import org.primefaces.ultima.domain.Player;
import org.primefaces.ultima.domain.Sale;

@ManagedBean(name="dtGroupView")
@ViewScoped
public class GroupView
implements Serializable {
    private static final String[] manufacturers = new String[10];
    private List<Sale> sales;
    private static final String[] playerNames;
    private List<Integer> years;
    private List<Player> players;

    @PostConstruct
    public void init() {
        int i;
        this.sales = new ArrayList();
        for (i = 0; i < 10; ++i) {
            this.sales.add(new Sale(manufacturers[i], this.getRandomAmount(), this.getRandomAmount(), this.getRandomPercentage(), this.getRandomPercentage()));
        }
        this.years = new ArrayList();
        this.years.add(2010);
        this.years.add(2011);
        this.years.add(2012);
        this.years.add(2013);
        this.years.add(2014);
        this.players = new ArrayList();
        for (i = 0; i < 10; ++i) {
            this.players.add(new Player(playerNames[i], this.generateRandomGoalStatsData()));
        }
    }

    public List<Sale> getSales() {
        return this.sales;
    }

    private int getRandomAmount() {
        return (int)(Math.random() * 100000.0);
    }

    private int getRandomPercentage() {
        return (int)(Math.random() * 100.0);
    }

    public String getLastYearTotal() {
        int total = 0;
        for (Sale sale : this.getSales()) {
            total += sale.getLastYearSale();
        }
        return new DecimalFormat("###,###.###").format(total);
    }

    public String getThisYearTotal() {
        int total = 0;
        for (Sale sale : this.getSales()) {
            total += sale.getThisYearSale();
        }
        return new DecimalFormat("###,###.###").format(total);
    }

    public List<Integer> getYears() {
        return this.years;
    }

    public int getYearCount() {
        return this.years.size();
    }

    public List<Player> getPlayers() {
        return this.players;
    }

    private Map<Integer, Integer> generateRandomGoalStatsData() {
        LinkedHashMap<Integer, Integer> stats = new LinkedHashMap<Integer, Integer>();
        for (int i = 0; i < 5; ++i) {
            stats.put((Integer)this.years.get(i), this.getRandomGoals());
        }
        return stats;
    }

    private int getRandomGoals() {
        return (int)(Math.random() * 50.0);
    }

    static {
        GroupView.manufacturers[0] = "Apple";
        GroupView.manufacturers[1] = "Samsung";
        GroupView.manufacturers[2] = "Microsoft";
        GroupView.manufacturers[3] = "Philips";
        GroupView.manufacturers[4] = "Sony";
        GroupView.manufacturers[5] = "LG";
        GroupView.manufacturers[6] = "Sharp";
        GroupView.manufacturers[7] = "Panasonic";
        GroupView.manufacturers[8] = "HTC";
        GroupView.manufacturers[9] = "Nokia";
        playerNames = new String[10];
        GroupView.playerNames[0] = "Lionel Messi";
        GroupView.playerNames[1] = "Cristiano Ronaldo";
        GroupView.playerNames[2] = "Arjen Robben";
        GroupView.playerNames[3] = "Franck Ribery";
        GroupView.playerNames[4] = "Ronaldinho";
        GroupView.playerNames[5] = "Luis Suarez";
        GroupView.playerNames[6] = "Sergio Aguero";
        GroupView.playerNames[7] = "Zlatan Ibrahimovic";
        GroupView.playerNames[8] = "Neymar Jr";
        GroupView.playerNames[9] = "Andres Iniesta";
    }
}

