/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.ultima.view.data.datatable;

import java.io.Serializable;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ManagedProperty;
import javax.faces.bean.ViewScoped;
import javax.faces.context.FacesContext;
import org.primefaces.event.CellEditEvent;
import org.primefaces.event.RowEditEvent;
import org.primefaces.ultima.domain.Car;
import org.primefaces.ultima.service.CarService;

@ManagedBean(name="dtEditView")
@ViewScoped
public class EditView
implements Serializable {
    private List<Car> cars1;
    private List<Car> cars2;
    @ManagedProperty(value="#{carService}")
    private CarService service;

    @PostConstruct
    public void init() {
        this.cars1 = this.service.createCars(10);
        this.cars2 = this.service.createCars(10);
    }

    public List<Car> getCars1() {
        return this.cars1;
    }

    public List<Car> getCars2() {
        return this.cars2;
    }

    public List<String> getBrands() {
        return this.service.getBrands();
    }

    public List<String> getColors() {
        return this.service.getColors();
    }

    public void setService(CarService service) {
        this.service = service;
    }

    public void onRowEdit(RowEditEvent event) {
        FacesMessage msg = new FacesMessage("Car Edited", ((Car)event.getObject()).getId());
        FacesContext.getCurrentInstance().addMessage(null, msg);
    }

    public void onRowCancel(RowEditEvent event) {
        FacesMessage msg = new FacesMessage("Edit Cancelled", ((Car)event.getObject()).getId());
        FacesContext.getCurrentInstance().addMessage(null, msg);
    }

    public void onCellEdit(CellEditEvent event) {
        Object oldValue = event.getOldValue();
        Object newValue = event.getNewValue();
        if (newValue != null && !newValue.equals(oldValue)) {
            FacesMessage msg = new FacesMessage(FacesMessage.SEVERITY_INFO, "Cell Changed", "Old: " + oldValue + ", New:" + newValue);
            FacesContext.getCurrentInstance().addMessage(null, msg);
        }
    }
}

