/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.ultima.view.data;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ManagedProperty;
import javax.faces.context.FacesContext;
import org.primefaces.event.SelectEvent;
import org.primefaces.event.UnselectEvent;
import org.primefaces.ultima.domain.Theme;
import org.primefaces.ultima.service.ThemeService;

@ManagedBean
public class OrderListView {
    @ManagedProperty(value="#{themeService}")
    private ThemeService service;
    private List<String> cities;
    private List<Theme> themes;

    @PostConstruct
    public void init() {
        this.cities = new ArrayList();
        this.cities.add("San Francisco");
        this.cities.add("London");
        this.cities.add("Paris");
        this.cities.add("Istanbul");
        this.cities.add("Berlin");
        this.cities.add("Barcelona");
        this.cities.add("Rome");
        this.themes = this.service.getThemes().subList(0, 6);
    }

    public ThemeService getService() {
        return this.service;
    }

    public void setService(ThemeService service) {
        this.service = service;
    }

    public List<String> getCities() {
        return this.cities;
    }

    public void setCities(List<String> cities) {
        this.cities = cities;
    }

    public List<Theme> getThemes() {
        return this.themes;
    }

    public void setThemes(List<Theme> themes) {
        this.themes = themes;
    }

    public void onSelect(SelectEvent event) {
        FacesContext context = FacesContext.getCurrentInstance();
        context.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, "Item Selected", event.getObject().toString()));
    }

    public void onUnselect(UnselectEvent event) {
        FacesContext context = FacesContext.getCurrentInstance();
        context.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, "Item Unselected", event.getObject().toString()));
    }

    public void onReorder() {
        FacesContext context = FacesContext.getCurrentInstance();
        context.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, "List Reordered", null));
    }
}

