/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.ultima.view;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import org.primefaces.event.ItemSelectEvent;
import org.primefaces.model.chart.Axis;
import org.primefaces.model.chart.AxisType;
import org.primefaces.model.chart.BarChartModel;
import org.primefaces.model.chart.BarChartSeries;
import org.primefaces.model.chart.BubbleChartModel;
import org.primefaces.model.chart.BubbleChartSeries;
import org.primefaces.model.chart.CartesianChartModel;
import org.primefaces.model.chart.CategoryAxis;
import org.primefaces.model.chart.ChartSeries;
import org.primefaces.model.chart.DateAxis;
import org.primefaces.model.chart.DonutChartModel;
import org.primefaces.model.chart.HorizontalBarChartModel;
import org.primefaces.model.chart.LineChartModel;
import org.primefaces.model.chart.LineChartSeries;
import org.primefaces.model.chart.LinearAxis;
import org.primefaces.model.chart.MeterGaugeChartModel;
import org.primefaces.model.chart.OhlcChartModel;
import org.primefaces.model.chart.OhlcChartSeries;
import org.primefaces.model.chart.PieChartModel;
import org.primefaces.ultima.view.ChartDemoView;

@ManagedBean(name="chartDemoView")
public class ChartDemoView
implements Serializable {
    private LineChartModel lineModel1;
    private LineChartModel lineModel2;
    private LineChartModel zoomModel;
    private CartesianChartModel combinedModel;
    private CartesianChartModel fillToZero;
    private LineChartModel areaModel;
    private BarChartModel barModel;
    private HorizontalBarChartModel horizontalBarModel;
    private PieChartModel pieModel1;
    private PieChartModel pieModel2;
    private DonutChartModel donutModel1;
    private DonutChartModel donutModel2;
    private MeterGaugeChartModel meterGaugeModel1;
    private MeterGaugeChartModel meterGaugeModel2;
    private BubbleChartModel bubbleModel1;
    private BubbleChartModel bubbleModel2;
    private OhlcChartModel ohlcModel;
    private OhlcChartModel ohlcModel2;
    private PieChartModel livePieModel;
    private LineChartModel animatedModel1;
    private BarChartModel animatedModel2;
    private LineChartModel multiAxisModel;
    private LineChartModel dateModel;

    @PostConstruct
    public void init() {
        this.createLineModels();
        this.createAreaModel();
        this.createPieModels();
        this.createDonutModels();
        this.createBubbleModels();
        this.createOhlcModels();
        this.createFillToZero();
        this.createMeterGaugeModels();
        this.createBarModels();
        this.createAnimatedModels();
        this.createCombinedModel();
        this.createMultiAxisModel();
        this.createDateModel();
    }

    public void itemSelect(ItemSelectEvent event) {
        FacesMessage msg = new FacesMessage(FacesMessage.SEVERITY_INFO, "Item selected", "Item Index: " + event.getItemIndex() + ", Series Index:" + event.getSeriesIndex());
        FacesContext.getCurrentInstance().addMessage(null, msg);
    }

    public LineChartModel getLineModel1() {
        return this.lineModel1;
    }

    public LineChartModel getLineModel2() {
        return this.lineModel2;
    }

    public LineChartModel getZoomModel() {
        return this.zoomModel;
    }

    public CartesianChartModel getCombinedModel() {
        return this.combinedModel;
    }

    public CartesianChartModel getAreaModel() {
        return this.areaModel;
    }

    public PieChartModel getPieModel1() {
        return this.pieModel1;
    }

    public PieChartModel getPieModel2() {
        return this.pieModel2;
    }

    public MeterGaugeChartModel getMeterGaugeModel1() {
        return this.meterGaugeModel1;
    }

    public MeterGaugeChartModel getMeterGaugeModel2() {
        return this.meterGaugeModel2;
    }

    public DonutChartModel getDonutModel1() {
        return this.donutModel1;
    }

    public DonutChartModel getDonutModel2() {
        return this.donutModel2;
    }

    public CartesianChartModel getFillToZero() {
        return this.fillToZero;
    }

    public BubbleChartModel getBubbleModel1() {
        return this.bubbleModel1;
    }

    public BubbleChartModel getBubbleModel2() {
        return this.bubbleModel2;
    }

    public OhlcChartModel getOhlcModel() {
        return this.ohlcModel;
    }

    public OhlcChartModel getOhlcModel2() {
        return this.ohlcModel2;
    }

    public BarChartModel getBarModel() {
        return this.barModel;
    }

    public HorizontalBarChartModel getHorizontalBarModel() {
        return this.horizontalBarModel;
    }

    public LineChartModel getAnimatedModel1() {
        return this.animatedModel1;
    }

    public BarChartModel getAnimatedModel2() {
        return this.animatedModel2;
    }

    public LineChartModel getMultiAxisModel() {
        return this.multiAxisModel;
    }

    public LineChartModel getDateModel() {
        return this.dateModel;
    }

    public PieChartModel getLivePieModel() {
        int random1 = (int)(Math.random() * 1000.0);
        int random2 = (int)(Math.random() * 1000.0);
        this.livePieModel.getData().put("Candidate 1", random1);
        this.livePieModel.getData().put("Candidate 2", random2);
        this.livePieModel.setTitle("Votes");
        this.livePieModel.setLegendPosition("ne");
        return this.livePieModel;
    }

    private LineChartModel initCategoryModel() {
        LineChartModel model = new LineChartModel();
        ChartSeries boys = new ChartSeries();
        boys.setLabel("Boys");
        boys.set((Object)"2004", (Number)120);
        boys.set((Object)"2005", (Number)100);
        boys.set((Object)"2006", (Number)44);
        boys.set((Object)"2007", (Number)150);
        boys.set((Object)"2008", (Number)25);
        ChartSeries girls = new ChartSeries();
        girls.setLabel("Girls");
        girls.set((Object)"2004", (Number)52);
        girls.set((Object)"2005", (Number)60);
        girls.set((Object)"2006", (Number)110);
        girls.set((Object)"2007", (Number)90);
        girls.set((Object)"2008", (Number)120);
        model.addSeries(boys);
        model.addSeries(girls);
        return model;
    }

    private void createLineModels() {
        this.lineModel1 = this.initLinearModel();
        this.lineModel1.setTitle("Linear Chart");
        this.lineModel1.setLegendPosition("e");
        Axis yAxis = this.lineModel1.getAxis(AxisType.Y);
        yAxis.setMin((Object)0);
        yAxis.setMax((Object)10);
        this.lineModel1.setExtender("skinChart");
        this.lineModel2 = this.initCategoryModel();
        this.lineModel2.setTitle("Category Chart");
        this.lineModel2.setLegendPosition("e");
        this.lineModel2.setShowPointLabels(true);
        this.lineModel2.getAxes().put(AxisType.X, new CategoryAxis("Years"));
        yAxis = this.lineModel2.getAxis(AxisType.Y);
        yAxis.setLabel("Births");
        yAxis.setMin((Object)0);
        yAxis.setMax((Object)200);
        this.zoomModel = this.initLinearModel();
        this.zoomModel.setTitle("Zoom");
        this.zoomModel.setZoom(true);
        this.zoomModel.setLegendPosition("e");
        yAxis = this.zoomModel.getAxis(AxisType.Y);
        yAxis.setMin((Object)0);
        yAxis.setMax((Object)10);
    }

    private void createAreaModel() {
        this.areaModel = new LineChartModel();
        LineChartSeries boys = new LineChartSeries();
        boys.setFill(true);
        boys.setLabel("Boys");
        boys.set((Object)"2004", (Number)120);
        boys.set((Object)"2005", (Number)100);
        boys.set((Object)"2006", (Number)44);
        boys.set((Object)"2007", (Number)150);
        boys.set((Object)"2008", (Number)25);
        LineChartSeries girls = new LineChartSeries();
        girls.setFill(true);
        girls.setLabel("Girls");
        girls.set((Object)"2004", (Number)52);
        girls.set((Object)"2005", (Number)60);
        girls.set((Object)"2006", (Number)110);
        girls.set((Object)"2007", (Number)90);
        girls.set((Object)"2008", (Number)120);
        this.areaModel.addSeries((ChartSeries)boys);
        this.areaModel.addSeries((ChartSeries)girls);
        this.areaModel.setTitle("Area Chart");
        this.areaModel.setLegendPosition("ne");
        this.areaModel.setStacked(true);
        this.areaModel.setShowPointLabels(true);
        CategoryAxis xAxis = new CategoryAxis("Years");
        this.areaModel.getAxes().put(AxisType.X, xAxis);
        Axis yAxis = this.areaModel.getAxis(AxisType.Y);
        yAxis.setLabel("Fails");
        yAxis.setMin((Object)0);
        yAxis.setMax((Object)300);
        this.areaModel.setExtender("skinArea");
    }

    private BarChartModel initBarModel() {
        BarChartModel model = new BarChartModel();
        ChartSeries boys = new ChartSeries();
        boys.setLabel("Boys");
        boys.set((Object)"2004", (Number)120);
        boys.set((Object)"2005", (Number)100);
        boys.set((Object)"2006", (Number)44);
        boys.set((Object)"2007", (Number)150);
        boys.set((Object)"2008", (Number)25);
        ChartSeries girls = new ChartSeries();
        girls.setLabel("Girls");
        girls.set((Object)"2004", (Number)52);
        girls.set((Object)"2005", (Number)60);
        girls.set((Object)"2006", (Number)110);
        girls.set((Object)"2007", (Number)135);
        girls.set((Object)"2008", (Number)120);
        model.addSeries(boys);
        model.addSeries(girls);
        return model;
    }

    private void createBarModels() {
        this.createBarModel();
        this.createHorizontalBarModel();
    }

    private void createBarModel() {
        this.barModel = this.initBarModel();
        this.barModel.setTitle("Bar Chart");
        this.barModel.setLegendPosition("ne");
        Axis xAxis = this.barModel.getAxis(AxisType.X);
        xAxis.setLabel("Gender");
        Axis yAxis = this.barModel.getAxis(AxisType.Y);
        yAxis.setLabel("Births");
        yAxis.setMin((Object)0);
        yAxis.setMax((Object)200);
        this.barModel.setExtender("skinBar");
    }

    private void createHorizontalBarModel() {
        this.horizontalBarModel = new HorizontalBarChartModel();
        ChartSeries boys = new ChartSeries();
        boys.setLabel("Boys");
        boys.set((Object)"2004", (Number)50);
        boys.set((Object)"2005", (Number)96);
        boys.set((Object)"2006", (Number)44);
        boys.set((Object)"2007", (Number)55);
        boys.set((Object)"2008", (Number)25);
        ChartSeries girls = new ChartSeries();
        girls.setLabel("Girls");
        girls.set((Object)"2004", (Number)52);
        girls.set((Object)"2005", (Number)60);
        girls.set((Object)"2006", (Number)82);
        girls.set((Object)"2007", (Number)35);
        girls.set((Object)"2008", (Number)120);
        this.horizontalBarModel.addSeries(boys);
        this.horizontalBarModel.addSeries(girls);
        this.horizontalBarModel.setTitle("Horizontal and Stacked");
        this.horizontalBarModel.setLegendPosition("e");
        this.horizontalBarModel.setStacked(true);
        Axis xAxis = this.horizontalBarModel.getAxis(AxisType.X);
        xAxis.setLabel("Sales");
        xAxis.setMin((Object)0);
        xAxis.setMax((Object)200);
        Axis yAxis = this.horizontalBarModel.getAxis(AxisType.Y);
        yAxis.setLabel("Gender");
    }

    private void createCombinedModel() {
        this.combinedModel = new BarChartModel();
        BarChartSeries boys = new BarChartSeries();
        boys.setLabel("Boys");
        boys.set((Object)"2004", (Number)120);
        boys.set((Object)"2005", (Number)100);
        boys.set((Object)"2006", (Number)44);
        boys.set((Object)"2007", (Number)150);
        boys.set((Object)"2008", (Number)25);
        LineChartSeries girls = new LineChartSeries();
        girls.setLabel("Girls");
        girls.set((Object)"2004", (Number)52);
        girls.set((Object)"2005", (Number)60);
        girls.set((Object)"2006", (Number)110);
        girls.set((Object)"2007", (Number)135);
        girls.set((Object)"2008", (Number)120);
        this.combinedModel.addSeries((ChartSeries)boys);
        this.combinedModel.addSeries((ChartSeries)girls);
        this.combinedModel.setTitle("Bar and Line");
        this.combinedModel.setLegendPosition("ne");
        this.combinedModel.setMouseoverHighlight(false);
        this.combinedModel.setShowDatatip(false);
        this.combinedModel.setShowPointLabels(true);
        Axis yAxis = this.combinedModel.getAxis(AxisType.Y);
        yAxis.setMin((Object)0);
        yAxis.setMax((Object)200);
        this.combinedModel.setExtender("skinBarAndLine");
    }

    private void createMultiAxisModel() {
        this.multiAxisModel = new LineChartModel();
        BarChartSeries boys = new BarChartSeries();
        boys.setLabel("Boys");
        boys.set((Object)"2004", (Number)120);
        boys.set((Object)"2005", (Number)100);
        boys.set((Object)"2006", (Number)44);
        boys.set((Object)"2007", (Number)150);
        boys.set((Object)"2008", (Number)25);
        LineChartSeries girls = new LineChartSeries();
        girls.setLabel("Girls");
        girls.setXaxis(AxisType.X2);
        girls.setYaxis(AxisType.Y2);
        girls.set((Object)"A", (Number)52);
        girls.set((Object)"B", (Number)60);
        girls.set((Object)"C", (Number)110);
        girls.set((Object)"D", (Number)135);
        girls.set((Object)"E", (Number)120);
        this.multiAxisModel.addSeries((ChartSeries)boys);
        this.multiAxisModel.addSeries((ChartSeries)girls);
        this.multiAxisModel.setTitle("Multi Axis Chart");
        this.multiAxisModel.setMouseoverHighlight(false);
        this.multiAxisModel.getAxes().put(AxisType.X, new CategoryAxis("Years"));
        this.multiAxisModel.getAxes().put(AxisType.X2, new CategoryAxis("Period"));
        Axis yAxis = this.multiAxisModel.getAxis(AxisType.Y);
        yAxis.setLabel("Birth");
        yAxis.setMin((Object)0);
        yAxis.setMax((Object)200);
        LinearAxis y2Axis = new LinearAxis("Number");
        y2Axis.setMin((Object)0);
        y2Axis.setMax((Object)200);
        this.multiAxisModel.getAxes().put(AxisType.Y2, y2Axis);
        this.multiAxisModel.setExtender("skinMultiAxis");
    }

    private void createOhlcModels() {
        this.createOhlcModel1();
        this.createOhlcModel2();
    }

    private void createOhlcModel1() {
        this.ohlcModel = new OhlcChartModel();
        this.ohlcModel.add(new OhlcChartSeries((Object)2007, 143.82, 144.56, 136.04, 136.97));
        this.ohlcModel.add(new OhlcChartSeries((Object)2008, 138.7, 139.68, 135.18, 135.4));
        this.ohlcModel.add(new OhlcChartSeries((Object)2009, 143.46, 144.66, 139.79, 140.02));
        this.ohlcModel.add(new OhlcChartSeries((Object)2010, 140.67, 143.56, 132.88, 142.44));
        this.ohlcModel.add(new OhlcChartSeries((Object)2011, 136.01, 139.5, 134.53, 139.48));
        this.ohlcModel.add(new OhlcChartSeries((Object)2012, 124.76, 135.9, 124.55, 135.81));
        this.ohlcModel.add(new OhlcChartSeries((Object)2012, 123.73, 129.31, 121.57, 122.5));
        this.ohlcModel.setTitle("OHLC Chart");
        this.ohlcModel.getAxis(AxisType.X).setLabel("Year");
        this.ohlcModel.getAxis(AxisType.Y).setLabel("Price Change $K/Unit");
    }

    private void createOhlcModel2() {
        this.ohlcModel2 = new OhlcChartModel();
        for (int i = 1; i < 41; ++i) {
            this.ohlcModel2.add(new OhlcChartSeries((Object)i, Math.random() * 80.0 + 80.0, Math.random() * 50.0 + 110.0, Math.random() * 20.0 + 80.0, Math.random() * 80.0 + 80.0));
        }
        this.ohlcModel2.setTitle("Candlestick");
        this.ohlcModel2.setCandleStick(true);
        this.ohlcModel2.getAxis(AxisType.X).setLabel("Sector");
        this.ohlcModel2.getAxis(AxisType.Y).setLabel("Index Value");
    }

    private void createBubbleModels() {
        this.bubbleModel1 = this.initBubbleModel();
        this.bubbleModel1.setTitle("Bubble Chart");
        this.bubbleModel1.getAxis(AxisType.X).setLabel("Price");
        Axis yAxis = this.bubbleModel1.getAxis(AxisType.Y);
        yAxis.setMin((Object)0);
        yAxis.setMax((Object)250);
        yAxis.setLabel("Labels");
        this.bubbleModel1.setExtender("skinBubble");
        this.bubbleModel2 = this.initBubbleModel();
        this.bubbleModel2.setTitle("Custom Options");
        this.bubbleModel2.setShadow(false);
        this.bubbleModel2.setBubbleGradients(true);
        this.bubbleModel2.setBubbleAlpha(0.8);
        this.bubbleModel2.getAxis(AxisType.X).setTickAngle(-50);
        yAxis = this.bubbleModel2.getAxis(AxisType.Y);
        yAxis.setMin((Object)0);
        yAxis.setMax((Object)250);
        yAxis.setTickAngle(50);
    }

    private BubbleChartModel initBubbleModel() {
        BubbleChartModel model = new BubbleChartModel();
        model.add(new BubbleChartSeries("Acura", 70, 183, 55));
        model.add(new BubbleChartSeries("Alfa Romeo", 45, 92, 36));
        model.add(new BubbleChartSeries("AM General", 24, 104, 40));
        model.add(new BubbleChartSeries("Bugatti", 50, 123, 60));
        model.add(new BubbleChartSeries("BMW", 15, 89, 25));
        model.add(new BubbleChartSeries("Audi", 40, 180, 80));
        model.add(new BubbleChartSeries("Aston Martin", 70, 70, 48));
        return model;
    }

    private LineChartModel initLinearModel() {
        LineChartModel model = new LineChartModel();
        LineChartSeries series1 = new LineChartSeries();
        series1.setLabel("Series 1");
        series1.set((Object)1, (Number)2);
        series1.set((Object)2, (Number)1);
        series1.set((Object)3, (Number)3);
        series1.set((Object)4, (Number)6);
        series1.set((Object)5, (Number)8);
        LineChartSeries series2 = new LineChartSeries();
        series2.setLabel("Series 2");
        series2.set((Object)1, (Number)6);
        series2.set((Object)2, (Number)3);
        series2.set((Object)3, (Number)2);
        series2.set((Object)4, (Number)7);
        series2.set((Object)5, (Number)9);
        model.addSeries((ChartSeries)series1);
        model.addSeries((ChartSeries)series2);
        return model;
    }

    private void createPieModels() {
        this.createPieModel1();
        this.createPieModel2();
        this.createLivePieModel();
    }

    private void createPieModel1() {
        this.pieModel1 = new PieChartModel();
        this.pieModel1.set("Brand 1", (Number)540);
        this.pieModel1.set("Brand 2", (Number)325);
        this.pieModel1.set("Brand 3", (Number)702);
        this.pieModel1.set("Brand 4", (Number)421);
        this.pieModel1.setTitle("Simple Pie");
        this.pieModel1.setLegendPosition("w");
        this.pieModel1.setExtender("skinPie");
    }

    private void createPieModel2() {
        this.pieModel2 = new PieChartModel();
        this.pieModel2.set("Brand 1", (Number)540);
        this.pieModel2.set("Brand 2", (Number)325);
        this.pieModel2.set("Brand 3", (Number)702);
        this.pieModel2.set("Brand 4", (Number)421);
        this.pieModel2.setTitle("Custom Pie");
        this.pieModel2.setLegendPosition("e");
        this.pieModel2.setFill(false);
        this.pieModel2.setShowDataLabels(true);
        this.pieModel2.setDiameter(150);
    }

    private void createDonutModels() {
        this.donutModel1 = this.initDonutModel();
        this.donutModel1.setTitle("Donut Chart");
        this.donutModel1.setLegendPosition("w");
        this.donutModel1.setExtender("skinDonut");
        this.donutModel2 = this.initDonutModel();
        this.donutModel2.setTitle("Custom Options");
        this.donutModel2.setLegendPosition("e");
        this.donutModel2.setSliceMargin(5);
        this.donutModel2.setShowDataLabels(true);
        this.donutModel2.setDataFormat("value");
        this.donutModel2.setShadow(false);
    }

    private DonutChartModel initDonutModel() {
        DonutChartModel model = new DonutChartModel();
        LinkedHashMap<String, Integer> circle1 = new LinkedHashMap<String, Integer>();
        circle1.put("Brand 1", 150);
        circle1.put("Brand 2", 400);
        circle1.put("Brand 3", 200);
        circle1.put("Brand 4", 10);
        model.addCircle(circle1);
        LinkedHashMap<String, Integer> circle2 = new LinkedHashMap<String, Integer>();
        circle2.put("Brand 1", 540);
        circle2.put("Brand 2", 125);
        circle2.put("Brand 3", 702);
        circle2.put("Brand 4", 421);
        model.addCircle(circle2);
        LinkedHashMap<String, Integer> circle3 = new LinkedHashMap<String, Integer>();
        circle3.put("Brand 1", 40);
        circle3.put("Brand 2", 325);
        circle3.put("Brand 3", 402);
        circle3.put("Brand 4", 421);
        model.addCircle(circle3);
        return model;
    }

    private void createLivePieModel() {
        this.livePieModel = new PieChartModel();
        this.livePieModel.set("Candidate 1", (Number)540);
        this.livePieModel.set("Candidate 2", (Number)325);
    }

    private void createFillToZero() {
        this.fillToZero = new CartesianChartModel();
        LineChartSeries series1 = new LineChartSeries();
        series1.setLabel("Series 1");
        series1.set((Object)"4, -3, 3, 6, 2, -2", (Number)0);
        this.fillToZero.addSeries((ChartSeries)series1);
    }

    private MeterGaugeChartModel initMeterGaugeModel() {
        1 intervals = new /* Unavailable Anonymous Inner Class!! */;
        return new MeterGaugeChartModel((Number)140, (List)intervals);
    }

    private void createMeterGaugeModels() {
        this.meterGaugeModel1 = this.initMeterGaugeModel();
        this.meterGaugeModel1.setTitle("MeterGauge Chart");
        this.meterGaugeModel1.setGaugeLabel("km/h");
        this.meterGaugeModel1.setGaugeLabelPosition("bottom");
        this.meterGaugeModel1.setExtender("skinMeterGauge");
        this.meterGaugeModel2 = this.initMeterGaugeModel();
        this.meterGaugeModel2.setTitle("Custom Options");
        this.meterGaugeModel2.setSeriesColors("66cc66,93b75f,E7E658,cc6666");
        this.meterGaugeModel2.setGaugeLabel("km/h");
        this.meterGaugeModel2.setGaugeLabelPosition("bottom");
        this.meterGaugeModel2.setShowTickLabels(false);
        this.meterGaugeModel2.setLabelHeightAdjust(110);
        this.meterGaugeModel2.setIntervalOuterRadius(Integer.valueOf(100));
    }

    private void createAnimatedModels() {
        this.animatedModel1 = this.initLinearModel();
        this.animatedModel1.setTitle("Line Chart");
        this.animatedModel1.setAnimate(true);
        this.animatedModel1.setLegendPosition("se");
        Axis yAxis = this.animatedModel1.getAxis(AxisType.Y);
        yAxis.setMin((Object)0);
        yAxis.setMax((Object)10);
        this.animatedModel2 = this.initBarModel();
        this.animatedModel2.setTitle("Bar Charts");
        this.animatedModel2.setAnimate(true);
        this.animatedModel2.setLegendPosition("ne");
        yAxis = this.animatedModel2.getAxis(AxisType.Y);
        yAxis.setMin((Object)0);
        yAxis.setMax((Object)200);
    }

    private void createDateModel() {
        this.dateModel = new LineChartModel();
        LineChartSeries series1 = new LineChartSeries();
        series1.setLabel("Series 1");
        series1.set((Object)"2014-01-01", (Number)51);
        series1.set((Object)"2014-01-06", (Number)22);
        series1.set((Object)"2014-01-12", (Number)65);
        series1.set((Object)"2014-01-18", (Number)74);
        series1.set((Object)"2014-01-24", (Number)24);
        series1.set((Object)"2014-01-30", (Number)51);
        LineChartSeries series2 = new LineChartSeries();
        series2.setLabel("Series 2");
        series2.set((Object)"2014-01-01", (Number)32);
        series2.set((Object)"2014-01-06", (Number)73);
        series2.set((Object)"2014-01-12", (Number)24);
        series2.set((Object)"2014-01-18", (Number)12);
        series2.set((Object)"2014-01-24", (Number)74);
        series2.set((Object)"2014-01-30", (Number)62);
        this.dateModel.addSeries((ChartSeries)series1);
        this.dateModel.addSeries((ChartSeries)series2);
        this.dateModel.setTitle("Zoom for Details");
        this.dateModel.setZoom(true);
        this.dateModel.getAxis(AxisType.Y).setLabel("Values");
        DateAxis axis = new DateAxis("Dates");
        axis.setTickAngle(-50);
        axis.setMax((Object)"2014-02-01");
        axis.setTickFormat("%b %#d, %y");
        this.dateModel.getAxes().put(AxisType.X, axis);
        this.dateModel.setExtender("skinZoom");
    }
}

