/*
 * Decompiled with CFR 0.152.
 */
package com.certuit.cercana.util;

import com.certuit.cercana.util.TimeAgo;
import com.certuit.cercana.view.base.ApplicationBean;
import com.lowagie.text.BadElementException;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.PdfPTable;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ViewScoped;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import javax.servlet.ServletContext;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFCreationHelper;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.util.IOUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@ManagedBean
@ViewScoped
public class JsfUtil
extends ApplicationBean
implements Serializable {
    private static final String RESORCES_FOLDER = "resources/main";
    private static final String IMAGE_FOLDER = "images";
    private static final String LOGOS_FOLDER = "logo";
    private String nombreReporte = "Reporte";

    public static SelectItem[] getSelectItems(List<?> entities, boolean selectOne) {
        int size = selectOne ? entities.size() + 1 : entities.size();
        SelectItem[] items = new SelectItem[size];
        int i = 0;
        if (selectOne) {
            items[0] = new SelectItem((Object)"", "---");
            ++i;
        }
        for (Object x : entities) {
            items[i++] = new SelectItem(x, x.toString());
        }
        return items;
    }

    public static void addErrorMessage(Exception ex, String defaultMsg) {
        String msg = ex.getLocalizedMessage();
        if (msg != null && msg.length() > 0) {
            JsfUtil.addErrorMessage((String)msg);
        } else {
            JsfUtil.addErrorMessage((String)defaultMsg);
        }
    }

    public static void addErrorMessages(List<String> messages) {
        for (String message : messages) {
            JsfUtil.addErrorMessage((String)message);
        }
    }

    public static void addErrorMessage(String msg) {
        FacesMessage facesMsg = new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, msg);
        FacesContext.getCurrentInstance().addMessage(null, facesMsg);
    }

    public static void addErrorMessage(String msg, String detail) {
        FacesMessage facesMsg = new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, detail);
        FacesContext.getCurrentInstance().addMessage(null, facesMsg);
    }

    public static void addSuccessMessage(String msg) {
        FacesMessage facesMsg = new FacesMessage(FacesMessage.SEVERITY_INFO, msg, msg);
        FacesContext.getCurrentInstance().addMessage("successInfo", facesMsg);
    }

    public static void addSuccessMessage(String msg, String detail) {
        FacesMessage facesMsg = new FacesMessage(FacesMessage.SEVERITY_INFO, msg, detail);
        FacesContext.getCurrentInstance().addMessage("successInfo", facesMsg);
    }

    public static String getRequestParameter(String key) {
        return (String)FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get(key);
    }

    public static Object getObjectFromRequestParameter(String requestParameterName, Converter converter, UIComponent component) {
        String theId = JsfUtil.getRequestParameter((String)requestParameterName);
        return converter.getAsObject(FacesContext.getCurrentInstance(), component, theId);
    }

    public void postProcessXLS(Object document) {
        FileInputStream in = null;
        HSSFWorkbook wb = (HSSFWorkbook)document;
        HSSFSheet sheet = wb.getSheetAt(0);
        HSSFRow header = sheet.getRow(0);
        HSSFFont font = wb.createFont();
        font.setColor((short)9);
        font.setBoldweight((short)1);
        HSSFCellStyle cellStyle = wb.createCellStyle();
        HSSFPalette palette = wb.getCustomPalette();
        palette.setColorAtIndex((short)57, (byte)51, (byte)-81, (byte)-34);
        cellStyle.setFillForegroundColor(palette.getColor(57).getIndex());
        cellStyle.setFillPattern((short)1);
        cellStyle.setFillBackgroundColor((short)9);
        cellStyle.setFont(font);
        for (int i = 0; i < header.getPhysicalNumberOfCells(); ++i) {
            header.getCell(i).setCellStyle(cellStyle);
            sheet.autoSizeColumn(i);
        }
        for (int x = 0; x < 6; ++x) {
            int createNewRowAt = 0;
            sheet.shiftRows(createNewRowAt, sheet.getLastRowNum(), 1, true, false);
            HSSFRow newRow = sheet.createRow(createNewRowAt);
            newRow = sheet.getRow(createNewRowAt);
        }
        HSSFFont fontTitle = wb.createFont();
        fontTitle.setBoldweight((short)1);
        fontTitle.setFontHeightInPoints((short)20);
        HSSFCellStyle titleStyle = wb.createCellStyle();
        titleStyle.setFont(fontTitle);
        HSSFRow row = sheet.createRow(4);
        Cell cell = row.createCell(0);
        cell.setCellValue(this.nombreReporte);
        cell.setCellStyle((CellStyle)titleStyle);
        try {
            in = new FileInputStream(this.getAbsolutePath("logo.png"));
            byte[] bytes = IOUtils.toByteArray((InputStream)in);
            int pictureIdx = wb.addPicture(bytes, 6);
            HSSFCreationHelper helper = wb.getCreationHelper();
            HSSFPatriarch drawing = sheet.createDrawingPatriarch();
            ClientAnchor anchor = helper.createClientAnchor();
            Picture picture = drawing.createPicture(anchor, pictureIdx);
            picture.resize(Double.MAX_VALUE);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void postProcessXLS2(Object document) {
        HSSFWorkbook wb = (HSSFWorkbook)document;
        HSSFSheet sheet = wb.getSheetAt(0);
        HSSFRow header = sheet.getRow(0);
        HSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setFillForegroundColor((short)17);
        for (int i = 0; i < header.getPhysicalNumberOfCells(); ++i) {
            HSSFCell cell = header.getCell(i);
            cell.setCellStyle(cellStyle);
        }
    }

    public void postProcessXLSOficial(Object document) {
        HSSFWorkbook wb = (HSSFWorkbook)document;
        HSSFSheet sheet = wb.getSheetAt(0);
        HSSFRow header = sheet.getRow(0);
        HSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setFillForegroundColor((short)17);
        for (int i = 0; i < header.getPhysicalNumberOfCells(); ++i) {
            HSSFCell cell = header.getCell(i);
            cell.setCellStyle(cellStyle);
        }
    }

    public void preProcessPDF(Object document) throws IOException, DocumentException {
        Document pdf = (Document)document;
        pdf.setPageSize(PageSize.A4);
        pdf.open();
        PdfPTable pdfTable = new PdfPTable(1);
        pdfTable.addCell(this.getImage("logo.png"));
        pdf.add((Element)this.getImage("logo.png"));
        pdf.add((Element)new Paragraph(this.nombreReporte, FontFactory.getFont((String)"Helvetica", (float)18.0f, (int)1, (Color)Color.WHITE)));
        pdf.add((Element)Chunk.NEWLINE);
    }

    public void postProcessPDF(Object document) throws IOException, DocumentException {
        Document pdf = (Document)document;
        pdf.setPageSize(PageSize.A4.rotate());
    }

    private Image getImage(String imageName) throws IOException, BadElementException {
        Image image = Image.getInstance((String)this.getAbsolutePath(imageName));
        image.scalePercent(90.0f);
        return image;
    }

    private String getAbsolutePath(String imageName) {
        ServletContext servletContext = (ServletContext)FacesContext.getCurrentInstance().getExternalContext().getContext();
        StringBuilder logo = new StringBuilder().append(servletContext.getRealPath(""));
        logo.append(File.separator).append("resources/main");
        logo.append(File.separator).append("images");
        logo.append(File.separator).append(imageName);
        System.out.println(logo);
        return logo.toString();
    }

    public static String getShortLongDateFormat(java.util.Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MMM/yy hh:mm:ss a");
        return sdf.format(date);
    }

    public static String getDateFormat(java.util.Date date, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        if (date == null) {
            return "";
        }
        return sdf.format(date);
    }

    public static String getFileSize(long fileSize) {
        DecimalFormat df = new DecimalFormat("#.##");
        if (fileSize > 0x100000L) {
            return df.format(fileSize / 0x100000L) + " MB";
        }
        if (fileSize > 1024L) {
            return df.format(fileSize / 1024L) + " KB";
        }
        return df.format(fileSize) + " B";
    }

    public static String saveFile(String fileName, String path, InputStream in) {
        String url = "";
        try {
            File file = new File(JsfUtil.getDestination() + path + fileName);
            FileOutputStream out = new FileOutputStream(file);
            int read = 0;
            byte[] bytes = new byte[2048];
            while ((read = in.read(bytes)) != -1) {
                ((OutputStream)out).write(bytes, 0, read);
            }
            in.close();
            out.flush();
            ((OutputStream)out).close();
            url = JsfUtil.getPublicUrl() + path + fileName;
            file.setReadable(true, false);
            System.out.println("New file created!");
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        return url;
    }

    public static String getTiempoTranscurrido(java.util.Date date) {
        String tiempoTanscurrido = "";
        TimeAgo time = new TimeAgo();
        if (date != null) {
            tiempoTanscurrido = time.timeAgo(date);
        }
        return tiempoTanscurrido;
    }

    public static java.util.Date getDateWithoutTime(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static java.util.Date getFullDayDate(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static java.util.Date getDateTime(java.util.Date date, int hourOfDay, int minute, int second, int millisecond) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, hourOfDay);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, millisecond);
        return calendar.getTime();
    }

    public static java.util.Date getDateTime(java.util.Date date, int dayOfMonth, int hourOfDay, int minute, int second, int millisecond) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, dayOfMonth);
        calendar.set(11, hourOfDay);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, millisecond);
        return calendar.getTime();
    }

    public static java.util.Date getDateTime(java.util.Date date, Time hora) {
        if (date != null && hora != null) {
            Calendar calendar = Calendar.getInstance();
            LocalTime localTime = LocalTime.parse(hora.toString());
            LocalDate localDate = new Date(date.getTime()).toLocalDate();
            calendar.set(localDate.getYear(), localDate.getMonthValue() - 1, localDate.getDayOfMonth(), localTime.getHour(), localTime.getMinute(), 0);
            return calendar.getTime();
        }
        return null;
    }

    public static String getDateNumbers(java.util.Date date) {
        String dateNumbers = "";
        if (date != null) {
            return JsfUtil.getDateFormat((java.util.Date)date, (String)"yyyy-MM-dd").replace("-", "");
        }
        return dateNumbers;
    }

    public static Time getTime(java.util.Date date) {
        Time time = new Time(date.getTime());
        return time;
    }

    public String getFechaDoubleAString(Double date) {
        String str = "0000-00-00 00:00";
        String minutos = "00";
        if (date != null) {
            try {
                if (date.toString().replace(".", "").length() >= 8) {
                    str = date.toString().replace(".", "");
                    str = str.replace("E", "0");
                    String ano = str.substring(0, 4);
                    String mes = str.substring(4, 6);
                    String dia = str.substring(6, 8);
                    String hora = str.substring(8, 10);
                    if (date.toString().replace(".", "").length() >= 12) {
                        minutos = str.substring(10, 12);
                    }
                    str = ano + "-" + mes + "-" + dia + " " + hora + ":" + minutos;
                    str = str.replace("E", "0");
                }
            }
            catch (NullPointerException e) {
                return str;
            }
        }
        return str;
    }

    public String getDateTimeDoubleAString(Double date) {
        String str = "0000-00-00 00:00";
        try {
            if (date.toString().replace(".", "").length() >= 8) {
                str = date.toString().replace(".", "");
                String ano = str.substring(0, 4);
                String mes = str.substring(4, 6);
                String dia = str.substring(6, 8);
                String hora = str.substring(8, 10);
                String minutos = str.substring(10, 12);
                str = ano + "-" + mes + "-" + dia + " " + hora + ":" + minutos;
                str.replace("E", "0");
            }
        }
        catch (NullPointerException e) {
            return str;
        }
        return str;
    }

    public String movilDate(Double date) {
        String str = this.getFechaDoubleAString(date);
        str = str.replace(" ", "");
        str = str.replace("-", "");
        str = str.replace(":", "");
        return str;
    }

    public static String getFormatNextTicket(int current_ticket_id) {
        java.util.Date date = new java.util.Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmm");
        String datetime = sdf.format(date);
        int ticket_number = current_ticket_id + 1;
        String ticketNumber = datetime.substring(0, 4);
        ticketNumber = ticketNumber + ticket_number;
        return ticketNumber;
    }

    public String getNombreReporte() {
        return this.nombreReporte;
    }

    public void setNombreReporte(String nombreReporte) {
        this.nombreReporte = nombreReporte;
    }
}

