/*
 * Decompiled with CFR 0.152.
 */
package com.certuit.cercana.service;

import com.certuit.cercana.domain.entity.vistas.ItemTableroVista;
import com.certuit.cercana.domain.entity.vistas.PLUVista;
import com.certuit.cercana.repositories.ItemTableroRepository;
import com.certuit.cercana.repositories.PLURepository;
import com.certuit.cercana.service.base.ServiceBase;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.repository.CrudRepository;
import org.springframework.stereotype.Service;

@Service
public class ItemTableroService
extends ServiceBase<ItemTableroVista, String> {
    @Autowired
    private ItemTableroRepository itemTableroRepository;
    @Autowired
    private PLURepository pluRepository;

    public ItemTableroService(CrudRepository<ItemTableroVista, String> repo) {
        super(repo);
    }

    public List<ItemTableroVista> getAll() {
        return this.itemTableroRepository.findAll();
    }

    public List<ItemTableroVista> getAllItemTablerosFromTablero(String tableroId, boolean withPLUs) {
        List itemTableroVistas = this.itemTableroRepository.findAllByTableroIdOrderByBotonAsc(tableroId);
        if (withPLUs) {
            for (ItemTableroVista itemTableroVista : itemTableroVistas) {
                if (itemTableroVista.getPluId() == null || itemTableroVista.getPluId().isEmpty()) continue;
                itemTableroVista.setPluVista((PLUVista)this.pluRepository.findOne((Serializable)((Object)itemTableroVista.getPluId())));
            }
        }
        return itemTableroVistas;
    }
}

