/*
 * Decompiled with CFR 0.152.
 */
package com.certuit.cercana.service;

import com.certuit.cercana.domain.entity.Cuenta;
import com.certuit.cercana.domain.entity.ImpTab;
import com.certuit.cercana.domain.entity.vistas.EmpleadoVista;
import com.certuit.cercana.domain.wrappers.CuentaWrapper;
import com.certuit.cercana.repositories.CuentaRepository;
import com.certuit.cercana.repositories.ImpTabRepository;
import com.certuit.cercana.service.CardexService;
import com.certuit.cercana.service.EmpleadoService;
import com.certuit.cercana.service.TerminalPosService;
import com.certuit.cercana.service.base.ServiceBase;
import com.certuit.cercana.util.TimeDateUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.repository.CrudRepository;
import org.springframework.stereotype.Service;

@Service
public class CuentaService
extends ServiceBase<Cuenta, Integer> {
    @Autowired
    private CuentaRepository cuentaRepository;
    @Autowired
    private ImpTabRepository impTabRepository;
    @Autowired
    private CardexService cardexService;
    @Autowired
    private TerminalPosService terminalPosService;
    @Autowired
    private EmpleadoService empleadoService;

    public CuentaService(CrudRepository<Cuenta, Integer> repo) {
        super(repo);
    }

    public List<Cuenta> getCuentasByMesero(String meseroNum) {
        return this.cuentaRepository.findAllByEmpleadoAbridorNumAndEstadoAbiertoAndSta(meseroNum, "0", "0");
    }

    public List<Cuenta> getAllCuentasByMesero(String meseroNum) {
        return this.cuentaRepository.findAllByEmpleadoAbridorNumAndEstadoAbierto(meseroNum, "0");
    }

    public List<Cuenta> getAllCuentas() {
        return this.cuentaRepository.findAll();
    }

    public ImpTab imprimirCuenta(Cuenta cuenta, String pos, String meseroId) {
        ImpTab impresionCuenta = new ImpTab();
        impresionCuenta.setPtr(cuenta.getId());
        impresionCuenta.setPos(pos);
        impresionCuenta.setEmpleadoImpr(meseroId);
        impresionCuenta.setStatus("0");
        impresionCuenta.setNota("0");
        cuenta.setNumeroImpreso(Integer.valueOf(cuenta.getNumeroImpreso() + 1));
        this.save((Object)cuenta);
        this.impTabRepository.save((Object)impresionCuenta);
        return impresionCuenta;
    }

    public List<CuentaWrapper> getCuentasWrapperByMesero(String meseroId) {
        ArrayList<CuentaWrapper> cuentaWrappers = new ArrayList<CuentaWrapper>();
        List cuentas = this.cuentaRepository.findAllByEmpleadoAbridorNumAndEstadoAbiertoAndSta(meseroId, "0", "0");
        for (Cuenta cuenta : cuentas) {
            CuentaWrapper cuentaWrapper = new CuentaWrapper();
            cuentaWrapper.setCuenta(cuenta);
            List cardexes = this.cardexService.getCardexesByCuenta(cuenta.getId());
            cuentaWrapper.setCardexes(cardexes);
            cuentaWrappers.add(cuentaWrapper);
            if (cuenta.getEmpleadoAbridorNum() == null) continue;
            cuenta.setEmpleadoAbridor((EmpleadoVista)this.empleadoService.findOne((Serializable)((Object)cuenta.getEmpleadoAbridorNum())));
        }
        return cuentaWrappers;
    }

    public Cuenta getCuenta(String numeroCuenta) {
        return this.cuentaRepository.findByCuentaAndEstadoAbierto(Cuenta.transformNumCuenta((String)numeroCuenta), "0");
    }

    private boolean isAlphaNumeric(String s) {
        return s != null && s.matches("^[a-zA-Z0-9]*$");
    }

    private boolean onlyDigits(String str, int n) {
        int i = 0;
        if (i < n) {
            return Character.isDigit(str.charAt(i));
        }
        return false;
    }

    public Cuenta saveCuenta(String numCuenta, String empleadoNum, String pos, String nombreCuenta, int numPersonas, int numNotas, int tipo) {
        Cuenta cuenta = new Cuenta();
        if (this.isAlphaNumeric(numCuenta)) {
            if (this.onlyDigits(numCuenta, numCuenta.length())) {
                cuenta.setCuenta(Cuenta.transformNumCuenta((String)numCuenta));
            } else {
                cuenta.setCuenta(numCuenta);
            }
        }
        cuenta.setEmpleadoAbridorNum(empleadoNum);
        cuenta.setHora(TimeDateUtils.getTime());
        cuenta.setFecha(TimeDateUtils.getTodayDate());
        cuenta.setPos(pos);
        cuenta.setNumPersonas(Integer.valueOf(numPersonas));
        cuenta.setNumNotas(Integer.valueOf(numNotas));
        cuenta.setTipoCuenta("5");
        cuenta.setSub(new BigDecimal(0));
        cuenta.setIva(new BigDecimal(0));
        cuenta.setCre(new BigDecimal(0));
        cuenta.setCam(new BigDecimal(0));
        cuenta.setFolio(Integer.valueOf(0));
        cuenta.setLocacion("1");
        cuenta.setSta("0");
        cuenta.setEnv(Integer.valueOf(0));
        cuenta.setNumeroImpreso(Integer.valueOf(0));
        cuenta.setTipVxt("0");
        cuenta.setEstadoAbierto("0");
        cuenta.setPro("0");
        cuenta.setPago1(new BigDecimal(0));
        cuenta.setPago2(new BigDecimal(0));
        cuenta.setPago3(new BigDecimal(0));
        cuenta.setPago4(new BigDecimal(0));
        cuenta.setPago5(new BigDecimal(0));
        cuenta.setPago6(new BigDecimal(0));
        cuenta.setPago7(new BigDecimal(0));
        cuenta.setPago8(new BigDecimal(0));
        cuenta.setPago9(new BigDecimal(0));
        cuenta.setDia(Integer.valueOf(TimeDateUtils.getTodayDayOfMonth()));
        if (!nombreCuenta.equals("")) {
            cuenta.setNombreCuenta(nombreCuenta);
        }
        if (tipo == -1) {
            cuenta.setTipo(this.terminalPosService.getPosByNum(pos).getTipo());
        } else {
            cuenta.setTipo(Integer.valueOf(tipo));
        }
        cuenta.setFwd("0");
        cuenta.setHom(Integer.valueOf(1));
        cuenta.setNota("1");
        cuenta.setStaEsEfe("0");
        cuenta.setSubCal(new BigDecimal(0));
        cuenta.setIvaCal(new BigDecimal(0));
        cuenta.setStaWeb(Integer.valueOf(0));
        return (Cuenta)this.cuentaRepository.save((Object)cuenta);
    }

    public int getAutoFolio() {
        return this.cuentaRepository.getCuentaAutomaticaNumber();
    }
}

