/*
 * Decompiled with CFR 0.152.
 */
package com.sierra.pdv.service;

import com.sierra.pdv.domain.entity.vistas.ItemTableroVista;
import com.sierra.pdv.domain.entity.vistas.TableroVista;
import com.sierra.pdv.domain.wrappers.TableroCuadroWrapper;
import com.sierra.pdv.repositories.TableroRepository;
import com.sierra.pdv.service.base.ServiceBase;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.repository.CrudRepository;
import org.springframework.stereotype.Service;

@Service
public class TableroService
extends ServiceBase<TableroVista, String> {
    @Autowired
    private TableroRepository tableroRepository;

    public TableroService(CrudRepository<TableroVista, String> repo) {
        super(repo);
    }

    public List<TableroVista> findAll() {
        return this.tableroRepository.findAll();
    }

    public List<TableroCuadroWrapper> transformTablero(TableroVista tablero, List<ItemTableroVista> itemsTablero) {
        ArrayList<TableroCuadroWrapper> tableroCuadroWrappers = new ArrayList<TableroCuadroWrapper>();
        try {
            if (tablero != null && itemsTablero != null && !itemsTablero.isEmpty()) {
                String tableroExh = tablero.getCuadroConfig();
                String tableroCua = tablero.getCuadroAspecto();
                block8: for (int i = 0; i < tableroExh.length(); ++i) {
                    char cuadroConfig = tableroCua.charAt(i);
                    char cuadroExt = tableroExh.charAt(i);
                    int boton = Integer.parseInt(itemsTablero.get(i).getBoton());
                    if (boton <= 0 || boton > 50) continue;
                    switch (cuadroConfig) {
                        case '3': {
                            if (cuadroExt == 'e' || boton == 10 || boton == 20 || boton == 30 || boton >= 40) continue block8;
                            ItemTableroVista itemTableroVista = itemsTablero.get(i);
                            tableroCuadroWrappers.add(TableroCuadroWrapper.createCuadroDobleDoble((String)itemTableroVista.getBoton(), (ItemTableroVista)itemsTablero.get(i)));
                            continue block8;
                        }
                        case '2': {
                            if (cuadroExt == 'e' || boton == 10 || boton == 20 || boton == 30 || boton == 40 || boton == 50) continue block8;
                            tableroCuadroWrappers.add(TableroCuadroWrapper.createCuadroDobleVertical((String)itemsTablero.get(i).getBoton(), (ItemTableroVista)itemsTablero.get(i)));
                            continue block8;
                        }
                        case '1': {
                            if (cuadroExt == 'e' || boton > 40) continue block8;
                            tableroCuadroWrappers.add(TableroCuadroWrapper.createCuadroDobleHorizontal((String)itemsTablero.get(i).getBoton(), (ItemTableroVista)itemsTablero.get(i)));
                            continue block8;
                        }
                        case '0': {
                            if (cuadroExt == 'e') continue block8;
                            tableroCuadroWrappers.add(TableroCuadroWrapper.createCuadroSencillo((String)itemsTablero.get(i).getBoton(), (ItemTableroVista)itemsTablero.get(i)));
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tableroCuadroWrappers;
    }

    public List<TableroCuadroWrapper> transformSecondTablero(TableroVista tablero, List<ItemTableroVista> itemsTablero) {
        ArrayList<TableroCuadroWrapper> tableroCuadroWrappers = new ArrayList<TableroCuadroWrapper>();
        try {
            if (tablero != null && itemsTablero != null && !itemsTablero.isEmpty()) {
                String tableroExh = tablero.getCuadroConfig();
                String tableroCua = tablero.getCuadroAspecto();
                block8: for (int i = 0; i < tableroExh.length(); ++i) {
                    char cuadroConfig = tableroCua.charAt(i);
                    char cuadroExt = tableroExh.charAt(i);
                    int boton = Integer.parseInt(itemsTablero.get(i).getBoton());
                    if (boton <= 50 || boton > 100) continue;
                    switch (cuadroConfig) {
                        case '3': {
                            if (cuadroExt == 'e' || boton == 60 || boton == 70 || boton == 80 || boton >= 90) continue block8;
                            ItemTableroVista itemTableroVista = itemsTablero.get(i);
                            tableroCuadroWrappers.add(TableroCuadroWrapper.createCuadroDobleDoble((String)itemTableroVista.getBoton(), (ItemTableroVista)itemsTablero.get(i)));
                            continue block8;
                        }
                        case '2': {
                            if (cuadroExt == 'e' || boton == 60 || boton == 70 || boton == 80 || boton == 90 || boton == 100) continue block8;
                            tableroCuadroWrappers.add(TableroCuadroWrapper.createCuadroDobleVertical((String)itemsTablero.get(i).getBoton(), (ItemTableroVista)itemsTablero.get(i)));
                            continue block8;
                        }
                        case '1': {
                            if (cuadroExt == 'e' || boton > 90) continue block8;
                            tableroCuadroWrappers.add(TableroCuadroWrapper.createCuadroDobleHorizontal((String)itemsTablero.get(i).getBoton(), (ItemTableroVista)itemsTablero.get(i)));
                            continue block8;
                        }
                        case '0': {
                            if (cuadroExt == 'e') continue block8;
                            tableroCuadroWrappers.add(TableroCuadroWrapper.createCuadroSencillo((String)itemsTablero.get(i).getBoton(), (ItemTableroVista)itemsTablero.get(i)));
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tableroCuadroWrappers;
    }

    public List<TableroCuadroWrapper> getUpperItems(TableroVista tablero, List<ItemTableroVista> itemsTablero) {
        ArrayList<TableroCuadroWrapper> tableroCuadroWrappers = new ArrayList<TableroCuadroWrapper>();
        Boolean alreadyThere = false;
        try {
            if (tablero != null && itemsTablero != null && !itemsTablero.isEmpty()) {
                for (int i = 0; i < itemsTablero.size(); ++i) {
                    if (itemsTablero.get(i).getPluVista() == null || itemsTablero.get(i).getPluVista().getTablaSig() == null || !itemsTablero.get(i).getPluVista().getId().startsWith("89")) continue;
                    ItemTableroVista itemTableroVista = itemsTablero.get(i);
                    for (int x = 0; x < tableroCuadroWrappers.size(); ++x) {
                        if (!((TableroCuadroWrapper)tableroCuadroWrappers.get(x)).getItemAspecto().getPluVista().getId().equals(itemTableroVista.getPluVista().getId())) continue;
                        alreadyThere = true;
                    }
                    if (alreadyThere.booleanValue()) continue;
                    tableroCuadroWrappers.add(TableroCuadroWrapper.createCuadroSencillo((String)itemTableroVista.getBoton(), (ItemTableroVista)itemsTablero.get(i)));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tableroCuadroWrappers;
    }

    public List<TableroCuadroWrapper> getItems(TableroVista tablero, List<ItemTableroVista> itemsTablero) {
        ArrayList<TableroCuadroWrapper> tableroCuadroWrappers = new ArrayList<TableroCuadroWrapper>();
        Boolean alreadyThere = false;
        try {
            if (tablero != null && itemsTablero != null && !itemsTablero.isEmpty()) {
                for (int i = 0; i < itemsTablero.size(); ++i) {
                    if (itemsTablero.get(i).getPluVista() == null || itemsTablero.get(i).getPluVista().getId().startsWith("89")) continue;
                    ItemTableroVista itemTableroVista = itemsTablero.get(i);
                    for (int x = 0; x < tableroCuadroWrappers.size(); ++x) {
                        if (!((TableroCuadroWrapper)tableroCuadroWrappers.get(x)).getItemAspecto().getPluVista().getId().equals(itemTableroVista.getPluVista().getId())) continue;
                        alreadyThere = true;
                    }
                    if (alreadyThere.booleanValue()) continue;
                    tableroCuadroWrappers.add(TableroCuadroWrapper.createCuadroSencillo((String)itemTableroVista.getBoton(), (ItemTableroVista)itemsTablero.get(i)));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tableroCuadroWrappers;
    }
}

