/*
 * Decompiled with CFR 0.152.
 */
package com.sierra.pdv.service;

import com.sierra.pdv.domain.entity.Cardex;
import com.sierra.pdv.domain.entity.Cuenta;
import com.sierra.pdv.domain.entity.DatosEmpresa;
import com.sierra.pdv.domain.entity.Empleados;
import com.sierra.pdv.domain.entity.ImpTab;
import com.sierra.pdv.domain.entity.PLUTicket;
import com.sierra.pdv.domain.entity.Pago;
import com.sierra.pdv.domain.entity.PagoTicket;
import com.sierra.pdv.domain.entity.ParametrosG;
import com.sierra.pdv.domain.entity.TicketInfo;
import com.sierra.pdv.domain.entity.vistas.EmpleadoVista;
import com.sierra.pdv.domain.entity.vistas.TerminalPosVista;
import com.sierra.pdv.domain.wrappers.CuentaWrapper;
import com.sierra.pdv.repositories.CuentaRepository;
import com.sierra.pdv.repositories.DatosEmpresaRepository;
import com.sierra.pdv.repositories.EmpleadosRepository;
import com.sierra.pdv.repositories.ImpTabRepository;
import com.sierra.pdv.repositories.PagoCuentaRepository;
import com.sierra.pdv.repositories.ParametrosGRepository;
import com.sierra.pdv.service.CardexService;
import com.sierra.pdv.service.EmpleadoService;
import com.sierra.pdv.service.TerminalPosService;
import com.sierra.pdv.service.base.ServiceBase;
import com.sierra.pdv.util.TimeDateUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.repository.CrudRepository;
import org.springframework.stereotype.Service;

@Service
public class CuentaService
extends ServiceBase<Cuenta, Integer> {
    @Autowired
    private CuentaRepository cuentaRepository;
    @Autowired
    private ImpTabRepository impTabRepository;
    @Autowired
    private CardexService cardexService;
    @Autowired
    private TerminalPosService terminalPosService;
    @Autowired
    private EmpleadoService empleadoService;
    @Autowired
    private DatosEmpresaRepository datosEmpresaRepository;
    @Autowired
    private ParametrosGRepository parametrosGRepository;
    @Autowired
    private EmpleadosRepository empleadosRepository;
    @Autowired
    private PagoCuentaRepository pagoCuentaRepository;

    public CuentaService(CrudRepository<Cuenta, Integer> repo) {
        super(repo);
    }

    public List<Cuenta> getCuentasByMesero(String meseroNum) {
        return this.cuentaRepository.findAllByEmpleadoAbridorNumAndEstadoAbiertoAndSta(meseroNum, "0", "0");
    }

    public List<Cuenta> getAllCuentasByMesero(String meseroNum) {
        return this.cuentaRepository.findAllByEmpleadoAbridorNumAndEstadoAbierto(meseroNum, "0");
    }

    public List<Cuenta> getAllCuentasByMesa(String mesaNum, String estado) {
        return this.cuentaRepository.findAllByCuentaAndEstadoAbierto(mesaNum, estado);
    }

    public List<Cuenta> getAllCuentas() {
        return this.cuentaRepository.findAll();
    }

    public ImpTab imprimirCuenta(Cuenta cuenta, String pos, String meseroId, String nota) {
        ImpTab impresionCuenta = new ImpTab();
        impresionCuenta.setPtr(cuenta.getId());
        impresionCuenta.setPos(pos);
        impresionCuenta.setEmpleadoImpr(meseroId);
        impresionCuenta.setStatus("0");
        impresionCuenta.setNota(nota);
        cuenta.setNumeroImpreso(Integer.valueOf(cuenta.getNumeroImpreso() + 1));
        this.save((Object)cuenta);
        this.impTabRepository.save((Object)impresionCuenta);
        return impresionCuenta;
    }

    public List<CuentaWrapper> getCuentasWrapperByMesero(String meseroId) {
        ArrayList<CuentaWrapper> cuentaWrappers = new ArrayList<CuentaWrapper>();
        List cuentas = this.cuentaRepository.findAllByEmpleadoAbridorNumAndEstadoAbiertoAndSta(meseroId, "0", "0");
        for (Cuenta cuenta : cuentas) {
            CuentaWrapper cuentaWrapper = new CuentaWrapper();
            cuentaWrapper.setCuenta(cuenta);
            List cardexes = this.cardexService.getCardexesByCuenta(cuenta.getId());
            cuentaWrapper.setCardexes(cardexes);
            cuentaWrappers.add(cuentaWrapper);
            if (cuenta.getEmpleadoAbridorNum() == null) continue;
            cuenta.setEmpleadoAbridor((EmpleadoVista)this.empleadoService.findOne((Serializable)((Object)cuenta.getEmpleadoAbridorNum())));
        }
        return cuentaWrappers;
    }

    public Cuenta getCuenta(String numeroCuenta, Boolean alphanumeric) {
        if (alphanumeric.booleanValue()) {
            return this.cuentaRepository.findByCuentaAndEstadoAbierto(numeroCuenta, "0");
        }
        return this.cuentaRepository.findByCuentaAndEstadoAbierto(Cuenta.transformNumCuenta((String)numeroCuenta), "0");
    }

    public Cuenta getCuentaByID(String ID) {
        Cuenta cuentaARegresar = null;
        List cuentas = this.cuentaRepository.findAll();
        for (Cuenta cuenta : cuentas) {
            if (!cuenta.getId().toString().equals(ID) || !cuenta.getEstadoAbierto().equals("0")) continue;
            cuentaARegresar = cuenta;
        }
        return cuentaARegresar;
    }

    public Cuenta getCuentaByNumCuenta(String numeroCuenta) {
        Cuenta cuentaARegresar = null;
        List cuentas = this.cuentaRepository.findAll();
        for (Cuenta cuenta : cuentas) {
            if (!cuenta.getCuenta().trim().equalsIgnoreCase(numeroCuenta) || !cuenta.getEstadoAbierto().equals("0")) continue;
            cuentaARegresar = cuenta;
        }
        return cuentaARegresar;
    }

    public boolean isAlphaNumeric(String s) {
        return s != null && s.matches("^[a-zA-Z0-9]*$");
    }

    public boolean onlyDigits(String str) {
        return str.matches("[0-9]+");
    }

    public Cuenta saveCuenta(String numCuenta, String empleadoNum, String pos, String nombreCuenta, int numPersonas, int numNotas, int tipo, Boolean alphanumeric) {
        Cuenta cuenta = new Cuenta();
        TerminalPosVista posObject = this.terminalPosService.getPosByNum(pos);
        if (alphanumeric.booleanValue()) {
            cuenta.setCuenta(numCuenta);
        } else {
            cuenta.setCuenta(Cuenta.transformNumCuenta((String)numCuenta));
        }
        cuenta.setEmpleadoAbridorNum(empleadoNum);
        cuenta.setHora(TimeDateUtils.getTime());
        cuenta.setFecha(TimeDateUtils.getTodayDate());
        cuenta.setPos(pos);
        cuenta.setNumPersonas(Integer.valueOf(numPersonas));
        cuenta.setNumNotas(Integer.valueOf(numNotas));
        cuenta.setTipoCuenta("5");
        cuenta.setSub(new BigDecimal(0));
        cuenta.setIva(new BigDecimal(0));
        cuenta.setCre(new BigDecimal(0));
        cuenta.setCam(new BigDecimal(0));
        cuenta.setFolio(Integer.valueOf(0));
        cuenta.setLocacion("" + posObject.getLoc());
        cuenta.setSta("0");
        cuenta.setEnv(Integer.valueOf(0));
        cuenta.setNumeroImpreso(Integer.valueOf(0));
        cuenta.setTipVxt("0");
        cuenta.setEstadoAbierto("0");
        cuenta.setPro("0");
        cuenta.setPago1(new BigDecimal(0));
        cuenta.setPago2(new BigDecimal(0));
        cuenta.setPago3(new BigDecimal(0));
        cuenta.setPago4(new BigDecimal(0));
        cuenta.setPago5(new BigDecimal(0));
        cuenta.setPago6(new BigDecimal(0));
        cuenta.setPago7(new BigDecimal(0));
        cuenta.setPago8(new BigDecimal(0));
        cuenta.setPago9(new BigDecimal(0));
        cuenta.setDia(Integer.valueOf(TimeDateUtils.getTodayDayOfMonth()));
        if (!nombreCuenta.equals("")) {
            cuenta.setNombreCuenta(nombreCuenta);
        }
        if (tipo == -1) {
            cuenta.setTipo(posObject.getTipo());
        } else {
            cuenta.setTipo(Integer.valueOf(tipo));
        }
        cuenta.setFwd("0");
        cuenta.setHom(Integer.valueOf(1));
        cuenta.setNota("0");
        cuenta.setStaEsEfe("0");
        cuenta.setSubCal(new BigDecimal(0));
        cuenta.setIvaCal(new BigDecimal(0));
        cuenta.setStaWeb(Integer.valueOf(0));
        return (Cuenta)this.cuentaRepository.save((Object)cuenta);
    }

    public Cuenta saveCuenta(String numCuenta, String empleadoNum, String pos, String nombreCuenta, int numPersonas, int numNotas, int tipo, Boolean alphanumeric, String clienteNum) {
        Cuenta cuenta = new Cuenta();
        TerminalPosVista posObject = this.terminalPosService.getPosByNum(pos);
        if (alphanumeric.booleanValue()) {
            cuenta.setCuenta(numCuenta);
        } else {
            cuenta.setCuenta(Cuenta.transformNumCuenta((String)numCuenta));
        }
        cuenta.setEmpleadoAbridorNum(empleadoNum);
        cuenta.setHora(TimeDateUtils.getTime());
        cuenta.setFecha(TimeDateUtils.getTodayDate());
        cuenta.setPos(pos);
        cuenta.setNumPersonas(Integer.valueOf(numPersonas));
        cuenta.setNumNotas(Integer.valueOf(numNotas));
        cuenta.setTipoCuenta("5");
        cuenta.setSub(new BigDecimal(0));
        cuenta.setIva(new BigDecimal(0));
        cuenta.setCre(new BigDecimal(0));
        cuenta.setCam(new BigDecimal(0));
        cuenta.setFolio(Integer.valueOf(0));
        cuenta.setLocacion("" + posObject.getLoc());
        cuenta.setSta("0");
        cuenta.setEnv(Integer.valueOf(0));
        cuenta.setNumeroImpreso(Integer.valueOf(0));
        cuenta.setTipVxt("0");
        cuenta.setEstadoAbierto("0");
        cuenta.setPro("0");
        cuenta.setPago1(new BigDecimal(0));
        cuenta.setPago2(new BigDecimal(0));
        cuenta.setPago3(new BigDecimal(0));
        cuenta.setPago4(new BigDecimal(0));
        cuenta.setPago5(new BigDecimal(0));
        cuenta.setPago6(new BigDecimal(0));
        cuenta.setPago7(new BigDecimal(0));
        cuenta.setPago8(new BigDecimal(0));
        cuenta.setPago9(new BigDecimal(0));
        cuenta.setDia(Integer.valueOf(TimeDateUtils.getTodayDayOfMonth()));
        if (!nombreCuenta.equals("")) {
            cuenta.setNombreCuenta(nombreCuenta);
        }
        if (tipo == -1) {
            cuenta.setTipo(posObject.getTipo());
        } else {
            cuenta.setTipo(Integer.valueOf(tipo));
        }
        cuenta.setFwd("0");
        cuenta.setHom(Integer.valueOf(1));
        cuenta.setNota("0");
        cuenta.setStaEsEfe("0");
        cuenta.setSubCal(new BigDecimal(0));
        cuenta.setIvaCal(new BigDecimal(0));
        cuenta.setStaWeb(Integer.valueOf(0));
        cuenta.setCliente(clienteNum);
        return (Cuenta)this.cuentaRepository.save((Object)cuenta);
    }

    public int getAutoFolio() {
        return this.cuentaRepository.getCuentaAutomaticaNumber();
    }

    public TicketInfo getInfoTicket(int cuentaID) {
        List datosEmpresa = this.datosEmpresaRepository.findAll();
        DatosEmpresa empresa = (DatosEmpresa)datosEmpresa.get(0);
        Cuenta cuenta = (Cuenta)this.cuentaRepository.findOne((Serializable)Integer.valueOf(cuentaID));
        Empleados empleados = (Empleados)this.empleadosRepository.findOne((Serializable)((Object)cuenta.getEmpleadoAbridorNum()));
        List plus = this.cardexService.getCardexesByCuenta(Integer.valueOf(cuentaID));
        ArrayList<PLUTicket> plusTicket = new ArrayList<PLUTicket>();
        List parametrosG = this.parametrosGRepository.findAll();
        ParametrosG parametros = (ParametrosG)parametrosG.get(0);
        double tipoDeCambio = parametros.getTipoCambio();
        Double dlls = cuenta.getSub().doubleValue() / tipoDeCambio;
        List pagos = this.pagoCuentaRepository.getPagosByPtr(Integer.valueOf(cuentaID));
        ArrayList<PagoTicket> pagosTicket = new ArrayList<PagoTicket>();
        for (Cardex cardex : plus) {
            if (cardex.getVod().equals("V")) continue;
            plusTicket.add(cardex.toPluTicket());
        }
        for (Pago pago : pagos) {
            pagosTicket.add(new PagoTicket(pago.getNombreCorto(), pago.getNombreCorto(), pago.getImporte()));
        }
        return new TicketInfo(cuentaID, empresa.getNombre(), empresa.getDomicilio(), empresa.getColonia(), empresa.getCiudad(), empresa.getRfc(), cuenta.getEmpleadoAbridorNum(), empleados.getNombreLargo(), cuenta.getNota(), cuenta.getNumPersonas().toString(), cuenta.getCuenta(), Double.valueOf(tipoDeCambio), cuenta.getFecha(), Double.valueOf(cuenta.getSub().doubleValue()), dlls, plusTicket, pagosTicket);
    }
}

