/*
 * Decompiled with CFR 0.152.
 */
package com.sierra.pdv.endpoint;

import com.sierra.pdv.domain.entity.TipoVenta;
import com.sierra.pdv.service.TipoVentaService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/tipoVenta"})
public class TipoVentaRest {
    private static final Logger log = LoggerFactory.getLogger(TipoVentaRest.class);
    private final TipoVentaService tipoVentaService;

    public TipoVentaRest(TipoVentaService tipoVentaService) {
        this.tipoVentaService = tipoVentaService;
    }

    @GetMapping(value={"/getAll"})
    public List<TipoVenta> getAll(@RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        StopWatch sw = this.start("GET /api/tipoVenta/getAll start corrId={}", new Object[]{corrId});
        List list = this.tipoVentaService.getAllTipoVenta();
        this.stop(sw, "GET /api/tipoVenta end corrId={} count={} timeMs={}", new Object[]{corrId, this.size(list), sw.getTotalTimeMillis()});
        return list;
    }

    private StopWatch start(String pattern, Object ... args) {
        StopWatch sw = new StopWatch();
        sw.start();
        log.info(pattern, args);
        return sw;
    }

    private void stop(StopWatch sw, String pattern, Object ... args) {
        if (sw.isRunning()) {
            sw.stop();
        }
        log.info(pattern, args);
    }

    private int size(List<?> list) {
        return list == null ? 0 : list.size();
    }
}

