/*
 * Decompiled with CFR 0.152.
 */
package com.sierra.pdv.endpoint;

import com.sierra.pdv.domain.entity.vistas.TerminalPosVista;
import com.sierra.pdv.exception.EntityNotFoundException;
import com.sierra.pdv.service.TerminalPosService;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/terminal"})
public class TerminalPosRest {
    private static final Logger log = LoggerFactory.getLogger(TerminalPosRest.class);
    private final TerminalPosService terminalPosService;

    public TerminalPosRest(TerminalPosService terminalPosService) {
        this.terminalPosService = terminalPosService;
    }

    @GetMapping
    public List<TerminalPosVista> getAllTerminalesPos(@RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        StopWatch sw = this.start("GET /api/terminal start corrId={}", new Object[]{corrId});
        List list = this.terminalPosService.getAllTerminales();
        this.stop(sw, "GET /api/terminal end corrId={} count={} timeMs={}", new Object[]{corrId, this.size(list), sw.getTotalTimeMillis()});
        return list;
    }

    @GetMapping(value={"/{posId}"})
    public TerminalPosVista getTerminal(@PathVariable(value="posId") String posID, @RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        StopWatch sw = this.start("GET /api/terminal/{} start corrId={}", new Object[]{posID, corrId});
        TerminalPosVista pos = (TerminalPosVista)this.terminalPosService.findOne((Serializable)((Object)posID));
        if (pos != null) {
            this.stop(sw, "GET /api/terminal/{} end corrId={} ok=true timeMs={}", new Object[]{posID, corrId, sw.getTotalTimeMillis()});
            return pos;
        }
        this.stop(sw, "GET /api/terminal/{} end corrId={} error=PosNoEncontrada timeMs={}", new Object[]{posID, corrId, sw.getTotalTimeMillis()});
        throw new EntityNotFoundException("La pos solicitada no fue encontrada");
    }

    private StopWatch start(String pattern, Object ... args) {
        StopWatch sw = new StopWatch();
        sw.start();
        log.info(pattern, args);
        return sw;
    }

    private void stop(StopWatch sw, String pattern, Object ... args) {
        if (sw.isRunning()) {
            sw.stop();
        }
        log.info(pattern, args);
    }

    private int size(List<?> list) {
        return list == null ? 0 : list.size();
    }
}

