/*
 * Decompiled with CFR 0.152.
 */
package com.sierra.pdv.endpoint;

import com.sierra.pdv.domain.entity.Tipo;
import com.sierra.pdv.domain.entity.vistas.ItemTableroVista;
import com.sierra.pdv.domain.entity.vistas.PLUVista;
import com.sierra.pdv.domain.entity.vistas.TableroVista;
import com.sierra.pdv.domain.wrappers.TableroCuadroWrapper;
import com.sierra.pdv.domain.wrappers.TableroWrapper;
import com.sierra.pdv.exception.EntityNotFoundException;
import com.sierra.pdv.repositories.TipoRepository;
import com.sierra.pdv.service.ItemTableroService;
import com.sierra.pdv.service.PLUService;
import com.sierra.pdv.service.TableroService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/tableros"})
public class TableroRest {
    private static final Logger log = LoggerFactory.getLogger(TableroRest.class);
    private final TableroService tableroService;
    private final ItemTableroService itemTableroService;
    private final PLUService pluService;
    private final TipoRepository tipoRepository;

    public TableroRest(TableroService tableroService, ItemTableroService itemTableroService, PLUService pluService, TipoRepository tipoRepository) {
        this.tableroService = tableroService;
        this.itemTableroService = itemTableroService;
        this.pluService = pluService;
        this.tipoRepository = tipoRepository;
    }

    @GetMapping
    public List<TableroVista> getAllTableros(@RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        StopWatch sw = this.start("GET /api/tableros start corrId={}", new Object[]{corrId});
        List list = this.tableroService.findAll();
        this.stop(sw, "GET /api/tableros end corrId={} count={} timeMs={}", new Object[]{corrId, this.size(list), sw.getTotalTimeMillis()});
        return list;
    }

    @GetMapping(value={"/{tableroId}"})
    public List<TableroWrapper> getTablero(@PathVariable String tableroId, @RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        StopWatch sw = this.start("GET /api/tableros/{} start corrId={}", new Object[]{tableroId, corrId});
        List itemTableroVistas = this.itemTableroService.getAllItemTablerosFromTablero(tableroId, false);
        List categorias = this.pluService.getAllCategories();
        ArrayList<TableroWrapper> tableroWrappers = new ArrayList<TableroWrapper>();
        for (PLUVista categoria : categorias) {
            TableroWrapper tableroWrapper = null;
            for (ItemTableroVista itemTableroVista : itemTableroVistas) {
                if (itemTableroVista.getPluId() == null) continue;
                boolean isAlreadyInList = false;
                if (tableroWrapper != null && tableroWrapper.getItemsTablero() != null) {
                    for (ItemTableroVista itemTableroVistaList : tableroWrapper.getItemsTablero()) {
                        if (itemTableroVistaList.getPluId() == null || !itemTableroVistaList.getPluId().equalsIgnoreCase(itemTableroVista.getPluId())) continue;
                        isAlreadyInList = true;
                        break;
                    }
                }
                if (isAlreadyInList || categoria.getId() == null || itemTableroVista.getPluId().trim().length() < 1 || !categoria.getId().trim().equalsIgnoreCase(itemTableroVista.getPluId().trim().substring(0, 1))) continue;
                if (tableroWrapper == null) {
                    tableroWrapper = new TableroWrapper();
                }
                if (tableroWrapper.getCategoria() == null) {
                    tableroWrapper.setCategoria(categoria);
                }
                if (tableroWrapper.getItemsTablero() == null) {
                    tableroWrapper.setItemsTablero(new ArrayList());
                }
                itemTableroVista.setCategoriaPLU(categoria);
                itemTableroVista.setPluVista((PLUVista)this.pluService.findOne((Serializable)((Object)itemTableroVista.getPluId())));
                String img = itemTableroVista.getImg();
                if (img != null) {
                    String ext;
                    int dot = (img = img.trim()).lastIndexOf(46);
                    if (dot > -1 && ".BMP".equalsIgnoreCase(ext = img.substring(dot))) {
                        img = null;
                    }
                    itemTableroVista.setImg(img);
                }
                tableroWrapper.getItemsTablero().add(itemTableroVista);
            }
            if (tableroWrapper == null) continue;
            tableroWrappers.add(tableroWrapper);
        }
        this.stop(sw, "GET /api/tableros/{} end corrId={} categorias={} items={} grupos={} timeMs={}", new Object[]{tableroId, corrId, this.size(categorias), this.size(itemTableroVistas), this.size(tableroWrappers), sw.getTotalTimeMillis()});
        return tableroWrappers;
    }

    @GetMapping(value={"/android/{tableroId}"})
    public List<TableroCuadroWrapper> getTableroAndroid(@PathVariable(value="tableroId") String tableroId, @RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        StopWatch sw = this.start("GET /api/tableros/android/{} start corrId={}", new Object[]{tableroId, corrId});
        TableroVista tablero = (TableroVista)this.tableroService.findOne((Serializable)((Object)tableroId));
        if (tablero != null) {
            List itemsTablero = this.itemTableroService.getAllItemTablerosFromTablero(tableroId, true);
            List res = this.tableroService.transformTablero(tablero, itemsTablero);
            this.stop(sw, "GET /api/tableros/android/{} end corrId={} items={} result={} timeMs={}", new Object[]{tableroId, corrId, this.size(itemsTablero), this.size(res), sw.getTotalTimeMillis()});
            return res;
        }
        this.stop(sw, "GET /api/tableros/android/{} end corrId={} error=TableroNoEncontrado timeMs={}", new Object[]{tableroId, corrId, sw.getTotalTimeMillis()});
        throw new EntityNotFoundException("El tablero solicitado no fue encontrado");
    }

    @GetMapping(value={"/secondBoard/{tableroId}"})
    public List<TableroCuadroWrapper> getSecondTableroAndroid(@PathVariable(value="tableroId") String tableroId, @RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        StopWatch sw = this.start("GET /api/tableros/secondBoard/{} start corrId={}", new Object[]{tableroId, corrId});
        TableroVista tablero = (TableroVista)this.tableroService.findOne((Serializable)((Object)tableroId));
        if (tablero != null) {
            List itemsTablero = this.itemTableroService.getAllItemTablerosFromTablero(tableroId, true);
            List res = this.tableroService.transformSecondTablero(tablero, itemsTablero);
            this.stop(sw, "GET /api/tableros/secondBoard/{} end corrId={} items={} result={} timeMs={}", new Object[]{tableroId, corrId, this.size(itemsTablero), this.size(res), sw.getTotalTimeMillis()});
            return res;
        }
        this.stop(sw, "GET /api/tableros/secondBoard/{} end corrId={} error=TableroNoEncontrado timeMs={}", new Object[]{tableroId, corrId, sw.getTotalTimeMillis()});
        throw new EntityNotFoundException("El tablero solicitado no fue encontrado");
    }

    @GetMapping(value={"/upper/{tableroId}"})
    public List<TableroCuadroWrapper> getUpperItems(@PathVariable(value="tableroId") String tableroId, @RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        StopWatch sw = this.start("GET /api/tableros/upper/{} start corrId={}", new Object[]{tableroId, corrId});
        TableroVista tablero = (TableroVista)this.tableroService.findOne((Serializable)((Object)tableroId));
        if (tablero != null) {
            List itemsTablero = this.itemTableroService.getAllItemTablerosFromTablero(tableroId, true);
            List res = this.tableroService.getUpperItems(tablero, itemsTablero);
            this.stop(sw, "GET /api/tableros/upper/{} end corrId={} items={} result={} timeMs={}", new Object[]{tableroId, corrId, this.size(itemsTablero), this.size(res), sw.getTotalTimeMillis()});
            return res;
        }
        this.stop(sw, "GET /api/tableros/upper/{} end corrId={} error=TableroNoEncontrado timeMs={}", new Object[]{tableroId, corrId, sw.getTotalTimeMillis()});
        throw new EntityNotFoundException("El tablero solicitado no fue encontrado");
    }

    @GetMapping(value={"/plus/{tableroId}"})
    public List<TableroCuadroWrapper> getItems(@PathVariable(value="tableroId") String tableroId, @RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        StopWatch sw = this.start("GET /api/tableros/plus/{} start corrId={}", new Object[]{tableroId, corrId});
        TableroVista tablero = (TableroVista)this.tableroService.findOne((Serializable)((Object)tableroId));
        if (tablero != null) {
            List itemsTablero = this.itemTableroService.getAllItemTablerosFromTablero(tableroId, true);
            List res = this.tableroService.getItems(tablero, itemsTablero);
            this.stop(sw, "GET /api/tableros/plus/{} end corrId={} items={} result={} timeMs={}", new Object[]{tableroId, corrId, this.size(itemsTablero), this.size(res), sw.getTotalTimeMillis()});
            return res;
        }
        this.stop(sw, "GET /api/tableros/plus/{} end corrId={} error=TableroNoEncontrado timeMs={}", new Object[]{tableroId, corrId, sw.getTotalTimeMillis()});
        throw new EntityNotFoundException("El tablero solicitado no fue encontrado");
    }

    @GetMapping(value={"/tablaTipo/{tipo}"})
    public Tipo getPrecioTipo(@PathVariable(value="tipo") Integer tipoID, @RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        StopWatch sw = this.start("GET /api/tableros/tablaTipo/{} start corrId={}", new Object[]{tipoID, corrId});
        Tipo tipo = (Tipo)this.tipoRepository.findOne((Serializable)tipoID);
        if (tipo != null) {
            this.stop(sw, "GET /api/tableros/tablaTipo/{} end corrId={} ok=true timeMs={}", new Object[]{tipoID, corrId, sw.getTotalTimeMillis()});
            return tipo;
        }
        this.stop(sw, "GET /api/tableros/tablaTipo/{} end corrId={} error=TipoNoEncontrado timeMs={}", new Object[]{tipoID, corrId, sw.getTotalTimeMillis()});
        throw new EntityNotFoundException("No existe el tipo con ese id");
    }

    private StopWatch start(String pattern, Object ... args) {
        StopWatch sw = new StopWatch();
        sw.start();
        log.info(pattern, args);
        return sw;
    }

    private void stop(StopWatch sw, String pattern, Object ... args) {
        if (sw.isRunning()) {
            sw.stop();
        }
        log.info(pattern, args);
    }

    private int size(List<?> list) {
        return list == null ? 0 : list.size();
    }
}

