/*
 * Decompiled with CFR 0.152.
 */
package com.sierra.pdv.endpoint;

import com.sierra.pdv.domain.entity.vistas.TabIvaVista;
import com.sierra.pdv.service.TabIvaService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/tabIva"})
public class TabIvaRest {
    private static final Logger log = LoggerFactory.getLogger(TabIvaRest.class);
    private final TabIvaService tabIvaService;

    public TabIvaRest(TabIvaService tabIvaService) {
        this.tabIvaService = tabIvaService;
    }

    @GetMapping
    public List<TabIvaVista> getAll(@RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        StopWatch sw = this.start("GET /api/tabIva start corrId={}", new Object[]{corrId});
        List list = this.tabIvaService.getAll();
        this.stop(sw, "GET /api/tabIva end corrId={} count={} timeMs={}", new Object[]{corrId, this.size(list), sw.getTotalTimeMillis()});
        return list;
    }

    private StopWatch start(String pattern, Object ... args) {
        StopWatch sw = new StopWatch();
        sw.start();
        log.info(pattern, args);
        return sw;
    }

    private void stop(StopWatch sw, String pattern, Object ... args) {
        if (sw.isRunning()) {
            sw.stop();
        }
        log.info(pattern, args);
    }

    private int size(List<?> list) {
        return list == null ? 0 : list.size();
    }
}

