/*
 * Decompiled with CFR 0.152.
 */
package com.sierra.pdv.endpoint;

import com.sierra.pdv.domain.entity.Reservacion;
import com.sierra.pdv.service.ReservacionService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StopWatch;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/reservacion"})
public class ReservacionRest {
    private static final Logger log = LoggerFactory.getLogger(ReservacionRest.class);
    private final ReservacionService reservacionService;

    public ReservacionRest(ReservacionService reservacionService) {
        this.reservacionService = reservacionService;
    }

    @GetMapping
    public List<Reservacion> getAllReservaciones(@RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        StopWatch sw = new StopWatch();
        sw.start();
        log.info("GET /api/reservacion start corrId={}", (Object)corrId);
        List list = this.reservacionService.getAllReservaciones();
        sw.stop();
        log.info("GET /api/reservacion end corrId={} count={} timeMs={}", new Object[]{corrId, list.size(), sw.getTotalTimeMillis()});
        return list;
    }

    @GetMapping(value={"/{reservacionId}"})
    public ResponseEntity<Reservacion> getMotivoCancelacionByID(@PathVariable(value="reservacionId") String id, @RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        StopWatch sw = new StopWatch();
        sw.start();
        log.info("GET /api/reservacion/{} start corrId={}", (Object)id, (Object)corrId);
        Reservacion reservacion = this.reservacionService.getReservacionByID(id);
        if (reservacion != null) {
            sw.stop();
            log.info("GET /api/reservacion/{} 200 OK corrId={} timeMs={}", new Object[]{id, corrId, sw.getTotalTimeMillis()});
            return new ResponseEntity((Object)reservacion, HttpStatus.OK);
        }
        sw.stop();
        log.warn("GET /api/reservacion/{} 404 NOT_FOUND corrId={} timeMs={}", new Object[]{id, corrId, sw.getTotalTimeMillis()});
        return new ResponseEntity(null, HttpStatus.NOT_FOUND);
    }
}

