/*
 * Decompiled with CFR 0.152.
 */
package com.sierra.pdv.endpoint;

import com.sierra.pdv.domain.entity.ParametrosG;
import com.sierra.pdv.service.ParametrosGService;
import com.sierra.pdv.util.Constants;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/parametrosGenerales"})
public class ParametrosGRest {
    private static final Logger log = LoggerFactory.getLogger(ParametrosGRest.class);
    private final ParametrosGService parametrosGService;

    public ParametrosGRest(ParametrosGService parametrosGService) {
        this.parametrosGService = parametrosGService;
    }

    @GetMapping
    public List<ParametrosG> getGralParams(@RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        StopWatch sw = this.start("GET /api/parametrosGenerales start corrId={}", new Object[]{corrId});
        List list = this.parametrosGService.getAllGralParams();
        this.stop(sw, "GET /api/parametrosGenerales end corrId={} count={} timeMs={}", new Object[]{corrId, this.size(list), sw.getTotalTimeMillis()});
        return list;
    }

    @GetMapping(value={"/serverState"})
    public boolean getServerState(@RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        StopWatch sw = this.start("GET /api/parametrosGenerales/serverState start corrId={}", new Object[]{corrId});
        List lista = this.parametrosGService.getAllGralParams();
        boolean state = lista != null;
        this.stop(sw, "GET /api/parametrosGenerales/serverState end corrId={} state={} timeMs={}", new Object[]{corrId, state, sw.getTotalTimeMillis()});
        return state;
    }

    @GetMapping(value={"/serverVersion"})
    public String getVersion(@RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        StopWatch sw = this.start("GET /api/parametrosGenerales/serverVersion start corrId={}", new Object[]{corrId});
        String version = Constants.VERSION_SERVER;
        this.stop(sw, "GET /api/parametrosGenerales/serverVersion end corrId={} version={} timeMs={}", new Object[]{corrId, version, sw.getTotalTimeMillis()});
        return version;
    }

    private StopWatch start(String pattern, Object ... args) {
        StopWatch sw = new StopWatch();
        sw.start();
        log.info(pattern, args);
        return sw;
    }

    private void stop(StopWatch sw, String pattern, Object ... args) {
        if (sw.isRunning()) {
            sw.stop();
        }
        log.info(pattern, args);
    }

    private int size(List<?> list) {
        return list == null ? 0 : list.size();
    }
}

