/*
 * Decompiled with CFR 0.152.
 */
package com.sierra.pdv.endpoint;

import com.sierra.pdv.domain.entity.vistas.PLUVista;
import com.sierra.pdv.domain.request.PlusByIDRequest;
import com.sierra.pdv.repositories.PLURepository;
import com.sierra.pdv.service.CardexService;
import com.sierra.pdv.service.PLUService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/plu"})
public class PLURest {
    private static final Logger log = LoggerFactory.getLogger(PLURest.class);
    private final PLURepository pluRepository;
    private final PLUService pluService;
    private final CardexService cardexService;

    public PLURest(PLURepository pluRepository, PLUService pluService, CardexService cardexService) {
        this.pluRepository = pluRepository;
        this.pluService = pluService;
        this.cardexService = cardexService;
    }

    @GetMapping
    public List<PLUVista> getAllPLUS(@RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        StopWatch sw = this.start("GET /api/plu start corrId={}", new Object[]{corrId});
        List list = this.pluService.getAllPLUS();
        this.stop(sw, "GET /api/plu end corrId={} count={} timeMs={}", new Object[]{corrId, this.size(list), sw.getTotalTimeMillis()});
        return list;
    }

    @GetMapping(value={"/categorias"})
    public List<PLUVista> getAllCategories(@RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        StopWatch sw = this.start("GET /api/plu/categorias start corrId={}", new Object[]{corrId});
        List list = this.pluService.getAllCategories();
        this.stop(sw, "GET /api/plu/categorias end corrId={} count={} timeMs={}", new Object[]{corrId, this.size(list), sw.getTotalTimeMillis()});
        return list;
    }

    @GetMapping(value={"/sub-categorias"})
    public List<PLUVista> getAllSubCategories(@RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        StopWatch sw = this.start("GET /api/plu/sub-categorias start corrId={}", new Object[]{corrId});
        List list = this.pluService.getAllSubCategories();
        this.stop(sw, "GET /api/plu/sub-categorias end corrId={} count={} timeMs={}", new Object[]{corrId, this.size(list), sw.getTotalTimeMillis()});
        return list;
    }

    @GetMapping(value={"/{pos}"})
    public int getPriceByEstrategy(@PathVariable String pos, @RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        StopWatch sw = this.start("GET /api/plu/{} start corrId={}", new Object[]{pos, corrId});
        int price = this.cardexService.getPriceByEstrategy(pos);
        this.stop(sw, "GET /api/plu/{} end corrId={} price={} timeMs={}", new Object[]{pos, corrId, price, sw.getTotalTimeMillis()});
        return price;
    }

    @GetMapping(value={"/categorias/{categoria}/{importe}"})
    public List<PLUVista> getPlusCategorias(@PathVariable(value="categoria") String categoria, @PathVariable(value="importe") String importe, @RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        StopWatch sw = this.start("GET /api/plu/categorias/{}/{} start corrId={}", new Object[]{categoria, importe, corrId});
        List list = this.pluService.getPlusSubCategories(categoria, importe);
        this.stop(sw, "GET /api/plu/categorias/{}/{} end corrId={} count={} timeMs={}", new Object[]{categoria, importe, corrId, this.size(list), sw.getTotalTimeMillis()});
        return list;
    }

    @PostMapping(value={"/byID"})
    public List<PLUVista> getPLUSByID(@RequestBody PlusByIDRequest plus, @RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        StopWatch sw = this.start("POST /api/plu/byID start corrId={} payloadSize={}", new Object[]{corrId, plus != null && plus.getPLUs() != null ? plus.getPLUs().size() : 0});
        List list = this.pluService.getPlusByID((List)plus.getPLUs());
        this.stop(sw, "POST /api/plu/byID end corrId={} resultCount={} timeMs={}", new Object[]{corrId, this.size(list), sw.getTotalTimeMillis()});
        return list;
    }

    private StopWatch start(String pattern, Object ... args) {
        StopWatch sw = new StopWatch();
        sw.start();
        log.info(pattern, args);
        return sw;
    }

    private void stop(StopWatch sw, String pattern, Object ... args) {
        if (sw.isRunning()) {
            sw.stop();
        }
        log.info(pattern, args);
    }

    private int size(List<?> list) {
        return list == null ? 0 : list.size();
    }
}

