/*
 * Decompiled with CFR 0.152.
 */
package com.sierra.pdv.endpoint;

import com.sierra.pdv.domain.entity.MotivoCancelacion;
import com.sierra.pdv.service.MotivoCanService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StopWatch;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/motivoCancelacion"})
public class MotivoCanRest {
    private static final Logger log = LoggerFactory.getLogger(MotivoCanRest.class);
    private final MotivoCanService motivoCanService;

    public MotivoCanRest(MotivoCanService motivoCanService) {
        this.motivoCanService = motivoCanService;
    }

    @GetMapping
    public List<MotivoCancelacion> getAllMotivos(@RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        StopWatch sw = this.start("GET /api/motivoCancelacion start corrId={}", new Object[]{corrId});
        List list = this.motivoCanService.getAllMotivos();
        this.stop(sw, "GET /api/motivoCancelacion end corrId={} count={} timeMs={}", new Object[]{corrId, this.size(list), sw.getTotalTimeMillis()});
        return list;
    }

    @GetMapping(value={"/{motivoId}"})
    public ResponseEntity<MotivoCancelacion> getMotivoCancelacionByID(@PathVariable(value="motivoId") int motivoID, @RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        StopWatch sw = this.start("GET /api/motivoCancelacion/{} start corrId={}", new Object[]{motivoID, corrId});
        MotivoCancelacion motivo = this.motivoCanService.getMotivosByID(Integer.valueOf(motivoID));
        ResponseEntity resp = motivo != null ? new ResponseEntity((Object)motivo, HttpStatus.OK) : new ResponseEntity(null, HttpStatus.NOT_FOUND);
        this.stop(sw, "GET /api/motivoCancelacion/{} end corrId={} status={} timeMs={}", new Object[]{motivoID, corrId, resp.getStatusCode().value(), sw.getTotalTimeMillis()});
        return resp;
    }

    private StopWatch start(String pattern, Object ... args) {
        StopWatch sw = new StopWatch();
        sw.start();
        log.info(pattern, args);
        return sw;
    }

    private void stop(StopWatch sw, String pattern, Object ... args) {
        if (sw.isRunning()) {
            sw.stop();
        }
        log.info(pattern, args);
    }

    private int size(List<?> list) {
        return list == null ? 0 : list.size();
    }
}

