/*
 * Decompiled with CFR 0.152.
 */
package com.sierra.pdv.endpoint;

import com.sierra.pdv.domain.entity.vistas.ItemTableroVista;
import com.sierra.pdv.service.ItemTableroService;
import com.sierra.pdv.service.PLUService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/item_tableros"})
public class ItemTableroRest {
    private static final Logger log = LoggerFactory.getLogger(ItemTableroRest.class);
    private final ItemTableroService itemTableroService;
    private final PLUService pluService;

    public ItemTableroRest(ItemTableroService itemTableroService, PLUService pluService) {
        this.itemTableroService = itemTableroService;
        this.pluService = pluService;
    }

    @GetMapping
    public List<ItemTableroVista> getAll(@RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        StopWatch sw = this.start("GET /api/item_tableros start corrId={}", new Object[]{corrId});
        List list = this.itemTableroService.getAll();
        this.stop(sw, "GET /api/item_tableros end corrId={} count={} timeMs={}", new Object[]{corrId, this.size(list), sw.getTotalTimeMillis()});
        return list;
    }

    @GetMapping(value={"/tablero/{id}"})
    public List<ItemTableroVista> getAllByTablero(@PathVariable String id, @RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        StopWatch sw = this.start("GET /api/item_tableros/tablero/{} start corrId={}", new Object[]{id, corrId});
        List list = this.itemTableroService.getAllItemTablerosFromTablero(id, true);
        this.stop(sw, "GET /api/item_tableros/tablero/{} end corrId={} count={} timeMs={}", new Object[]{id, corrId, this.size(list), sw.getTotalTimeMillis()});
        return list;
    }

    private StopWatch start(String pattern, Object ... args) {
        StopWatch sw = new StopWatch();
        sw.start();
        log.info(pattern, args);
        return sw;
    }

    private void stop(StopWatch sw, String pattern, Object ... args) {
        if (sw.isRunning()) {
            sw.stop();
        }
        log.info(pattern, args);
    }

    private int size(List<?> list) {
        return list == null ? 0 : list.size();
    }
}

