/*
 * Decompiled with CFR 0.152.
 */
package com.sierra.pdv.endpoint;

import com.sierra.pdv.domain.entity.vistas.EstrategiaPrecios;
import com.sierra.pdv.service.EstrategiaPreciosService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/pep"})
public class EstrategiaPreciosRest {
    private static final Logger log = LoggerFactory.getLogger(EstrategiaPreciosRest.class);
    private final EstrategiaPreciosService estrategiaPreciosService;

    public EstrategiaPreciosRest(EstrategiaPreciosService estrategiaPreciosService) {
        this.estrategiaPreciosService = estrategiaPreciosService;
    }

    @GetMapping(value={"/{pos}"})
    public List<EstrategiaPrecios> obtenerEstrategiaPorPos(@PathVariable(value="pos") String pos, @RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        StopWatch sw = this.start("GET /api/pep/{} start corrId={}", new Object[]{pos, corrId});
        List list = this.estrategiaPreciosService.getAllByPos(pos);
        this.stop(sw, "GET /api/pep/{} end corrId={} count={} timeMs={}", new Object[]{pos, corrId, this.size(list), sw.getTotalTimeMillis()});
        return list;
    }

    private StopWatch start(String pattern, Object ... args) {
        StopWatch sw = new StopWatch();
        sw.start();
        log.info(pattern, args);
        return sw;
    }

    private void stop(StopWatch sw, String pattern, Object ... args) {
        if (sw.isRunning()) {
            sw.stop();
        }
        log.info(pattern, args);
    }

    private int size(List<?> list) {
        return list == null ? 0 : list.size();
    }
}

