/*
 * Decompiled with CFR 0.152.
 */
package com.sierra.pdv.endpoint;

import com.sierra.pdv.domain.entity.vistas.EmpleadoVista;
import com.sierra.pdv.exception.EntityNotFoundException;
import com.sierra.pdv.service.EmpleadoService;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/empleado"})
public class EmpleadoRest {
    private static final Logger log = LoggerFactory.getLogger(EmpleadoRest.class);
    private final EmpleadoService empleadoService;

    public EmpleadoRest(EmpleadoService empleadoService) {
        this.empleadoService = empleadoService;
    }

    @GetMapping
    public List<EmpleadoVista> getAllEmpleados(@RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        StopWatch sw = this.start("GET /api/empleado start corrId={}", new Object[]{corrId});
        List list = this.empleadoService.getAllEmpleados();
        this.stop(sw, "GET /api/empleado end corrId={} count={} timeMs={}", new Object[]{corrId, this.size(list), sw.getTotalTimeMillis()});
        return list;
    }

    @GetMapping(value={"/byId/{idEmployee}"})
    public EmpleadoVista getEmpleado(@PathVariable(value="idEmployee") String id, @RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        StopWatch sw = this.start("GET /api/empleado/byId/{} start corrId={}", new Object[]{id, corrId});
        EmpleadoVista empleado = (EmpleadoVista)this.empleadoService.findOne((Serializable)((Object)id));
        if (empleado != null) {
            this.stop(sw, "GET /api/empleado/byId/{} 200 OK corrId={} timeMs={}", new Object[]{id, corrId, sw.getTotalTimeMillis()});
            return empleado;
        }
        this.stop(sw, "GET /api/empleado/byId/{} 404 NOT_FOUND corrId={} timeMs={}", new Object[]{id, corrId, sw.getTotalTimeMillis()});
        throw new EntityNotFoundException("Empleado no encontrado");
    }

    @PostMapping(value={"/login"})
    public EmpleadoVista loginEmpleado(@RequestParam(value="num_empleado") String empleadoId, @RequestParam(value="deviceId") String deviceId, @RequestParam(value="pos") String pos, @RequestParam(value="ipTablet") String ipTablet, @RequestHeader(value="X-Correlation-Id", required=false) String corrId) throws Exception {
        StopWatch sw = this.start("POST /api/empleado/login start corrId={} empId={} pos={} deviceId={} ip={}", new Object[]{corrId, this.clip(empleadoId), this.clip(pos), this.clip(deviceId), this.clip(ipTablet)});
        EmpleadoVista empleado = (EmpleadoVista)this.empleadoService.findOne((Serializable)((Object)empleadoId));
        if (empleado != null) {
            if (empleado.getStatus() == 0 || empleado.getStatus() != 0) {
                if (empleado.getTurno() == 1) {
                    if (this.posAuth(empleado.getVec_emp_pos(), pos)) {
                        empleado.setStatus(1);
                        empleado.setDeviceId(deviceId);
                        this.empleadoService.save((Object)empleado);
                        this.stop(sw, "POST /api/empleado/login end corrId={} ok=true timeMs={}", new Object[]{corrId, sw.getTotalTimeMillis()});
                        return empleado;
                    }
                    this.stop(sw, "POST /api/empleado/login end corrId={} error=TerminalNoAutorizada timeMs={}", new Object[]{corrId, sw.getTotalTimeMillis()});
                    throw new Exception("Terminal NO Autorizada para el empleado: " + empleadoId);
                }
                this.stop(sw, "POST /api/empleado/login end corrId={} error=NoEnTurno timeMs={}", new Object[]{corrId, sw.getTotalTimeMillis()});
                throw new EntityNotFoundException("El empleado con n\u00famero: " + empleadoId + " no est\u00e1 en turno");
            }
            this.stop(sw, "POST /api/empleado/login end corrId={} error=YaOrdenando timeMs={}", new Object[]{corrId, sw.getTotalTimeMillis()});
            throw new Exception("El empleado con el n\u00famero: " + empleadoId + " ya est\u00e1 ordenando");
        }
        this.stop(sw, "POST /api/empleado/login end corrId={} 404 NOT_FOUND timeMs={}", new Object[]{corrId, sw.getTotalTimeMillis()});
        throw new EntityNotFoundException("El empleado con n\u00famero: " + empleadoId + " no fue encontrado");
    }

    @PostMapping(value={"logout"})
    public EmpleadoVista logoutEmpleado(@RequestParam(value="num_empleado") String empleadoId, @RequestParam(value="pos") String pos, @RequestParam(value="ipTablet") String ipTablet, @RequestHeader(value="X-Correlation-Id", required=false) String corrId) throws Exception {
        StopWatch sw = this.start("POST /api/empleado/logout start corrId={} empId={} pos={} ip={}", new Object[]{corrId, this.clip(empleadoId), this.clip(pos), this.clip(ipTablet)});
        EmpleadoVista empleado = (EmpleadoVista)this.empleadoService.findOne((Serializable)((Object)empleadoId));
        if (empleado != null) {
            empleado.setStatus(0);
            this.empleadoService.save((Object)empleado);
            this.stop(sw, "POST /api/empleado/logout end corrId={} ok=true timeMs={}", new Object[]{corrId, sw.getTotalTimeMillis()});
        } else {
            this.stop(sw, "POST /api/empleado/logout end corrId={} warn=EmpleadoNoEncontrado timeMs={}", new Object[]{corrId, sw.getTotalTimeMillis()});
        }
        return empleado;
    }

    @PostMapping(value={"seg"})
    public EmpleadoVista obtenerEmpleado(@RequestParam(value="num_empleado") String empleadoId, @RequestParam(value="password") String pass, @RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        String contra;
        StopWatch sw = this.start("POST /api/empleado/seg start corrId={} empId={} pass={}", new Object[]{corrId, this.clip(empleadoId), this.mask(pass)});
        EmpleadoVista empleado = (EmpleadoVista)this.empleadoService.findOne((Serializable)((Object)empleadoId));
        if (empleado == null) {
            this.stop(sw, "POST /api/empleado/seg end corrId={} error=EmpleadoNoEncontrado timeMs={}", new Object[]{corrId, sw.getTotalTimeMillis()});
            throw new EntityNotFoundException("La contrase\u00f1a no coincide o no tiene autorizaci\u00f3n");
        }
        String string = contra = empleado.getContrasena() == null ? "" : empleado.getContrasena().trim();
        if (contra.equals(pass) && "9".equals(empleado.getAutorizacion())) {
            this.stop(sw, "POST /api/empleado/seg end corrId={} ok=true timeMs={}", new Object[]{corrId, sw.getTotalTimeMillis()});
            return empleado;
        }
        this.stop(sw, "POST /api/empleado/seg end corrId={} error=CredencialesInvalidas timeMs={}", new Object[]{corrId, sw.getTotalTimeMillis()});
        throw new EntityNotFoundException("La contrase\u00f1a no coincide o no tiene autorizaci\u00f3n");
    }

    private StopWatch start(String pattern, Object ... args) {
        StopWatch sw = new StopWatch();
        sw.start();
        log.info(pattern, args);
        return sw;
    }

    private void stop(StopWatch sw, String pattern, Object ... args) {
        if (sw.isRunning()) {
            sw.stop();
        }
        log.info(pattern, args);
    }

    private int size(List<?> list) {
        return list == null ? 0 : list.size();
    }

    private String clip(String s) {
        if (s == null) {
            return "null";
        }
        return s.length() <= 64 ? s : s.substring(0, 61) + "...";
    }

    private String mask(String s) {
        if (s == null) {
            return "null";
        }
        int n = Math.min(3, s.length());
        int maskLen = Math.max(0, s.length() - n);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < maskLen; ++i) {
            sb.append('*');
        }
        sb.append(s.substring(s.length() - n));
        return sb.toString();
    }

    private boolean posAuth(String posVec, String pos) {
        if (posVec == null || pos == null) {
            return false;
        }
        try {
            int idx = Integer.parseInt(pos) - 1;
            if (idx < 0 || idx >= posVec.length()) {
                return false;
            }
            return posVec.charAt(idx) != '1';
        }
        catch (NumberFormatException e) {
            log.warn("posAuth parse fail pos={} vecLen={}", (Object)pos, posVec != null ? Integer.valueOf(posVec.length()) : null);
            return false;
        }
    }
}

