/*
 * Decompiled with CFR 0.152.
 */
package com.sierra.pdv.endpoint;

import com.sierra.pdv.domain.entity.AutomaticAccountResponse;
import com.sierra.pdv.domain.entity.Cuenta;
import com.sierra.pdv.domain.entity.ImpTab;
import com.sierra.pdv.domain.entity.TicketInfo;
import com.sierra.pdv.domain.request.OrdenRequest;
import com.sierra.pdv.exception.CuentaNoAbiertaException;
import com.sierra.pdv.exception.EntityException;
import com.sierra.pdv.exception.EntityExistsException;
import com.sierra.pdv.exception.EntityNotFoundException;
import com.sierra.pdv.repositories.CuentaRepository;
import com.sierra.pdv.repositories.ImpTabRepository;
import com.sierra.pdv.service.CardexService;
import com.sierra.pdv.service.CuentaService;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StopWatch;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cuenta"})
public class CuentaRest {
    private static final Logger log = LoggerFactory.getLogger(CuentaRest.class);
    private final CuentaService cuentaService;
    private final CuentaRepository cuentaRepository;
    private final ImpTabRepository impTabRepository;
    private final CardexService cardexService;

    public CuentaRest(CuentaService cuentaService, CuentaRepository cuentaRepository, ImpTabRepository impTabRepository, CardexService cardexService) {
        this.cuentaService = cuentaService;
        this.cuentaRepository = cuentaRepository;
        this.impTabRepository = impTabRepository;
        this.cardexService = cardexService;
    }

    @GetMapping(value={"/{meseroId}"})
    public List<Cuenta> getCuentasByMesero(@PathVariable(value="meseroId") String meseroId, @RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        StopWatch sw = this.start("GET /api/cuenta/{meseroId} start meseroId=%s corrId=%s", new Object[]{meseroId, corrId});
        List list = this.cuentaService.getCuentasByMesero(meseroId);
        this.stop(sw, "GET /api/cuenta/{meseroId} end corrId={} count={} timeMs={}", new Object[]{corrId, this.size(list), sw.getTotalTimeMillis()});
        return list;
    }

    @GetMapping(value={"/getAllCuentaByMesa/{mesaNum}"})
    public List<Cuenta> getCuentasByMesa(@PathVariable(value="mesaNum") String mesaNum) {
        return this.cuentaService.getAllCuentasByMesa(mesaNum, "0");
    }

    @GetMapping
    public List<Cuenta> getAllAccounts(@RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        StopWatch sw = this.start("GET /api/cuenta start corrId={}", new Object[]{corrId});
        List list = this.cuentaService.getAllCuentas();
        this.stop(sw, "GET /api/cuenta end corrId={} count={} timeMs={}", new Object[]{corrId, this.size(list), sw.getTotalTimeMillis()});
        return list;
    }

    @GetMapping(value={"/byID/{ID_cuenta}"})
    public ResponseEntity<Cuenta> getAccountByID(@PathVariable(value="ID_cuenta") String accountID, @RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        StopWatch sw = this.start("GET /api/cuenta/byID/{} start corrId={}", new Object[]{accountID, corrId});
        Cuenta cuenta = this.cuentaService.getCuentaByID(accountID);
        ResponseEntity resp = cuenta != null ? new ResponseEntity((Object)cuenta, HttpStatus.OK) : new ResponseEntity(null, HttpStatus.NOT_FOUND);
        this.stop(sw, "GET /api/cuenta/byID/{} end corrId={} status={} timeMs={}", new Object[]{accountID, corrId, resp.getStatusCode().value(), sw.getTotalTimeMillis()});
        return resp;
    }

    @GetMapping(value={"/byNumCuenta/{num_cuenta}"})
    public ResponseEntity<Cuenta> getAccountByCuenta(@PathVariable(value="num_cuenta") String numeroCuenta, @RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        StopWatch sw = this.start("GET /api/cuenta/byNumCuenta/{} start corrId={}", new Object[]{numeroCuenta, corrId});
        Cuenta cuenta = this.cuentaService.getCuentaByNumCuenta(numeroCuenta);
        ResponseEntity resp = cuenta != null ? new ResponseEntity((Object)cuenta, HttpStatus.OK) : new ResponseEntity(null, HttpStatus.NOT_FOUND);
        this.stop(sw, "GET /api/cuenta/byNumCuenta/{} end corrId={} status={} timeMs={}", new Object[]{numeroCuenta, corrId, resp.getStatusCode().value(), sw.getTotalTimeMillis()});
        return resp;
    }

    @PostMapping(value={"/imprimirCuenta/{num_cuenta}"})
    public ResponseEntity<ImpTab> imprimirCuenta(@PathVariable(value="num_cuenta") String numCuenta, @RequestParam(name="pos") String pos, @RequestParam(value="emp_imp") String empImp, @RequestParam(value="nota") Optional<String> nota, @RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        StopWatch sw = this.start("POST /api/cuenta/imprimirCuenta/{} start corrId={} pos={} emp_imp={} notaPresent={}", new Object[]{numCuenta, corrId, this.clip(pos), this.clip(empImp), nota.isPresent()});
        Cuenta cuenta = (Cuenta)this.cuentaService.findOne((Serializable)Integer.valueOf(Integer.parseInt(numCuenta)));
        if (cuenta != null) {
            String notaAImprimir = nota.orElse("1");
            ImpTab impresion = this.cuentaService.imprimirCuenta(cuenta, pos, empImp, notaAImprimir);
            if (impresion != null) {
                this.stop(sw, "POST /api/cuenta/imprimirCuenta/{} 200 OK corrId={} timeMs={}", new Object[]{numCuenta, corrId, sw.getTotalTimeMillis()});
                return new ResponseEntity((Object)impresion, HttpStatus.OK);
            }
            this.stop(sw, "POST /api/cuenta/imprimirCuenta/{} ERROR corrId={} timeMs={}", new Object[]{numCuenta, corrId, sw.getTotalTimeMillis()});
            throw new EntityException("Ha ocurrido un error al imprimir esta cuenta. Contacte con soporte t\u00e9cnico.");
        }
        this.stop(sw, "POST /api/cuenta/imprimirCuenta/{} NOT_FOUND corrId={} timeMs={}", new Object[]{numCuenta, corrId, sw.getTotalTimeMillis()});
        throw new EntityExistsException("Ha ocurrido un error al imprimir esta cuenta. Contacte con soporte t\u00e9cnico.");
    }

    @PostMapping(value={"/abrir"})
    public ResponseEntity<Cuenta> abrirCuenta(@RequestParam(value="num_cuenta") String numCuenta, @RequestParam(value="num_empleado") String empleadoNum, @RequestParam(name="num_personas", required=false) Integer numeroPersonas, @RequestParam(name="pos", required=false) String pos, @RequestParam(name="num_notas", required=false) Integer numeroNotas, @RequestParam(name="nombre_cuenta", required=false) String nombreCuenta, @RequestParam(name="tipo_cuenta", required=false) Integer tipoCuenta, @RequestParam(name="alphanumeric", required=false) Boolean alphanumeric, @RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        Cuenta cuenta;
        StopWatch sw = this.start("POST /api/cuenta/abrir start corrId={} num_cuenta={} empl={} personas={} pos={} notas={} nombre={} tipo={} alphanumeric={}", new Object[]{corrId, this.clip(numCuenta), this.clip(empleadoNum), numeroPersonas, this.clip(pos), numeroNotas, this.clip(nombreCuenta), tipoCuenta, alphanumeric});
        if (alphanumeric == null) {
            alphanumeric = !this.cuentaService.onlyDigits(numCuenta);
        }
        if ((cuenta = this.cuentaService.getCuenta(numCuenta, alphanumeric)) == null) {
            Cuenta newCuenta = this.cuentaService.saveCuenta(numCuenta, empleadoNum, pos, nombreCuenta, numeroPersonas.intValue(), numeroNotas.intValue(), tipoCuenta.intValue(), alphanumeric);
            if (newCuenta != null) {
                this.stop(sw, "POST /api/cuenta/abrir 200 OK corrId={} id={} timeMs={}", new Object[]{corrId, newCuenta.getId(), sw.getTotalTimeMillis()});
                return new ResponseEntity((Object)newCuenta, HttpStatus.OK);
            }
            this.stop(sw, "POST /api/cuenta/abrir ERROR corrId={} timeMs={}", new Object[]{corrId, sw.getTotalTimeMillis()});
            throw new EntityException("Ha ocurrido un error al abrir esta cuenta. Contacte con soporte t\u00e9cnico.");
        }
        this.stop(sw, "POST /api/cuenta/abrir CONFLICT corrId={} timeMs={}", new Object[]{corrId, sw.getTotalTimeMillis()});
        throw new EntityExistsException("La cuenta que desea abrir ya se encuentra abierta");
    }

    @GetMapping(value={"getCountAllCuentasEmpleado/{meseroId}"})
    public int checkForEmpLimit(@PathVariable(value="meseroId") String meseroId, @RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        StopWatch sw = this.start("GET /api/cuenta/getCountAllCuentasEmpleado/{} start corrId={}", new Object[]{meseroId, corrId});
        int count = this.cuentaService.getAllCuentasByMesero(meseroId).size();
        this.stop(sw, "GET /api/cuenta/getCountAllCuentasEmpleado/{} end corrId={} count={} timeMs={}", new Object[]{meseroId, corrId, count, sw.getTotalTimeMillis()});
        return count;
    }

    @PostMapping(value={"/{cuenta_id}/ordenar"})
    public Cuenta ordenarCuenta(@PathVariable(value="cuenta_id") Integer cuentaId, @RequestParam(value="plus") String plus, @RequestParam(name="pos", required=false) String pos, @RequestParam(value="emp_ord") String empOrd, @RequestParam(value="cantidades") String cantidades, @RequestParam(value="precios") String precios, @RequestParam(value="cambios") String cambios, @RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        StopWatch sw = this.start("POST /api/cuenta/{}/ordenar start corrId={} pos={} emp={} plusLen={} cantLen={} precLen={} cambLen={}", new Object[]{cuentaId, corrId, this.clip(pos), this.clip(empOrd), this.len(plus), this.len(cantidades), this.len(precios), this.len(cambios)});
        Cuenta cuenta = (Cuenta)this.cuentaService.findOne((Serializable)cuentaId);
        if (cuenta != null) {
            String status = cuenta.getSta();
            String cobrada = cuenta.getEstadoAbierto();
            if (status != null && "0".equalsIgnoreCase(cobrada)) {
                Cuenta result = this.cardexService.ordenarCuenta(cuenta, plus, pos, empOrd, cantidades, precios, cambios);
                this.stop(sw, "POST /api/cuenta/{}/ordenar end corrId={} ok=true timeMs={}", new Object[]{cuentaId, corrId, sw.getTotalTimeMillis()});
                return result;
            }
            this.stop(sw, "POST /api/cuenta/{}/ordenar end corrId={} error=CuentaNoAbierta timeMs={}", new Object[]{cuentaId, corrId, sw.getTotalTimeMillis()});
            throw new CuentaNoAbiertaException("La cuenta en la que intenta ordenar est\u00e1 abierta o ya fue cobrada");
        }
        this.stop(sw, "POST /api/cuenta/{}/ordenar end corrId={} error=CuentaNoExiste timeMs={}", new Object[]{cuentaId, corrId, sw.getTotalTimeMillis()});
        throw new EntityNotFoundException("La cuenta en la que intenta ordenar no existe.");
    }

    @PostMapping(value={"/{cuenta_id}/ordenarCuenta"})
    public Cuenta ordenarCuenta(@PathVariable(value="cuenta_id") Integer cuentaId, @RequestBody OrdenRequest orden, @RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        StopWatch sw = this.start("POST /api/cuenta/{}/ordenarCuenta start corrId={} payload={}", new Object[]{cuentaId, corrId, this.summarizeOrden(orden)});
        Cuenta cuenta = (Cuenta)this.cuentaService.findOne((Serializable)cuentaId);
        if (cuenta != null) {
            String status = cuenta.getSta();
            String cobrada = cuenta.getEstadoAbierto();
            if (status != null && "0".equalsIgnoreCase(cobrada)) {
                Cuenta result = this.cardexService.ordenarCuenta(cuenta, orden);
                this.stop(sw, "POST /api/cuenta/{}/ordenarCuenta end corrId={} ok=true timeMs={}", new Object[]{cuentaId, corrId, sw.getTotalTimeMillis()});
                return result;
            }
            this.stop(sw, "POST /api/cuenta/{}/ordenarCuenta end corrId={} error=CuentaNoAbierta timeMs={}", new Object[]{cuentaId, corrId, sw.getTotalTimeMillis()});
            throw new CuentaNoAbiertaException("La cuenta en la que intenta ordenar est\u00e1 abierta o ya fue cobrada");
        }
        this.stop(sw, "POST /api/cuenta/{}/ordenarCuenta end corrId={} error=CuentaNoExiste timeMs={}", new Object[]{cuentaId, corrId, sw.getTotalTimeMillis()});
        throw new EntityNotFoundException("La cuenta en la que intenta ordenar no existe.");
    }

    @PostMapping(value={"/{cuenta_id}/cambiarStatus"})
    public Cuenta changeStatus(@PathVariable(value="cuenta_id") Integer cuentaId, @RequestParam(value="status") String status, @RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        StopWatch sw = this.start("POST /api/cuenta/{}/cambiarStatus start corrId={} status={}", new Object[]{cuentaId, corrId, this.clip(status)});
        Cuenta cuenta = (Cuenta)this.cuentaService.findOne((Serializable)cuentaId);
        cuenta.setSta(status);
        this.cuentaService.save((Object)cuenta);
        this.stop(sw, "POST /api/cuenta/{}/cambiarStatus end corrId={} ok=true timeMs={}", new Object[]{cuentaId, corrId, sw.getTotalTimeMillis()});
        return cuenta;
    }

    @PutMapping(value={"/{cuenta_id}"})
    public Cuenta asignarNombre(@PathVariable(value="cuenta_id") Integer cuentaId, @RequestParam(value="name") String nombre, @RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        StopWatch sw = this.start("PUT /api/cuenta/{} start corrId={} name={}", new Object[]{cuentaId, corrId, this.clip(nombre)});
        Cuenta cuenta = (Cuenta)this.cuentaService.findOne((Serializable)cuentaId);
        if (cuenta == null) {
            this.stop(sw, "PUT /api/cuenta/{} end corrId={} error=CuentaNoExiste timeMs={}", new Object[]{cuentaId, corrId, sw.getTotalTimeMillis()});
            throw new EntityNotFoundException("La cuenta en la que intenta operar no existe.");
        }
        cuenta.setNombreCuenta(nombre);
        this.cuentaService.save((Object)cuenta);
        this.stop(sw, "PUT /api/cuenta/{} end corrId={} ok=true timeMs={}", new Object[]{cuentaId, corrId, sw.getTotalTimeMillis()});
        return cuenta;
    }

    @PutMapping(value={"/setType/{cuenta_id}"})
    public Cuenta cambiarTipoVenta(@PathVariable(value="cuenta_id") Integer cuentaId, @RequestParam(value="type") int tipo, @RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        StopWatch sw = this.start("PUT /api/cuenta/setType/{} start corrId={} type={}", new Object[]{cuentaId, corrId, tipo});
        Cuenta cuenta = (Cuenta)this.cuentaService.findOne((Serializable)cuentaId);
        if (cuenta == null) {
            this.stop(sw, "PUT /api/cuenta/setType/{} end corrId={} error=CuentaNoExiste timeMs={}", new Object[]{cuentaId, corrId, sw.getTotalTimeMillis()});
            throw new EntityNotFoundException("La cuenta en la que intenta operar no existe.");
        }
        cuenta.setTipo(Integer.valueOf(tipo));
        this.cuentaService.save((Object)cuenta);
        this.stop(sw, "PUT /api/cuenta/setType/{} end corrId={} ok=true timeMs={}", new Object[]{cuentaId, corrId, sw.getTotalTimeMillis()});
        return cuenta;
    }

    @GetMapping(value={"/cuentaAutomatica"})
    public AutomaticAccountResponse getAutomaticAccountFolio(@RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        StopWatch sw = this.start("GET /api/cuenta/cuentaAutomatica start corrId={}", new Object[]{corrId});
        int folio = this.cuentaService.getAutoFolio();
        this.stop(sw, "GET /api/cuenta/cuentaAutomatica end corrId={} folio={} timeMs={}", new Object[]{corrId, folio, sw.getTotalTimeMillis()});
        return new AutomaticAccountResponse(Boolean.valueOf(true), folio);
    }

    @GetMapping(value={"/checkPrintTimes/{cuenta_id}"})
    public Cuenta checkForPrintTimes(@PathVariable(value="cuenta_id") Integer cuentaId, @RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        StopWatch sw = this.start("GET /api/cuenta/checkPrintTimes/{} start corrId={}", new Object[]{cuentaId, corrId});
        Cuenta cuenta = (Cuenta)this.cuentaService.findOne((Serializable)cuentaId);
        if (cuenta == null) {
            this.stop(sw, "GET /api/cuenta/checkPrintTimes/{} end corrId={} error=CuentaNoExiste timeMs={}", new Object[]{cuentaId, corrId, sw.getTotalTimeMillis()});
            throw new EntityNotFoundException("La cuenta en la que intenta operar no existe.");
        }
        this.stop(sw, "GET /api/cuenta/checkPrintTimes/{} end corrId={} ok=true timeMs={}", new Object[]{cuentaId, corrId, sw.getTotalTimeMillis()});
        return cuenta;
    }

    @GetMapping(value={"/allOpenAccounts"})
    public List<Cuenta> getAllOpenAccounts(@RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        StopWatch sw = this.start("GET /api/cuenta/allOpenAccounts start corrId={}", new Object[]{corrId});
        List list = this.cuentaRepository.findAllByEstadoAbiertoAndSta("0", "0");
        this.stop(sw, "GET /api/cuenta/allOpenAccounts end corrId={} count={} timeMs={}", new Object[]{corrId, this.size(list), sw.getTotalTimeMillis()});
        return list;
    }

    @DeleteMapping(value={"/cerrarCuenta/{cuenta_id}"})
    public Cuenta eliminarCuenta(@PathVariable(value="cuenta_id") Integer cuentaID, @RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        StopWatch sw = this.start("DELETE /api/cuenta/cerrarCuenta/{} start corrId={}", new Object[]{cuentaID, corrId});
        Cuenta cuenta = (Cuenta)this.cuentaService.findOne((Serializable)cuentaID);
        if (cuenta != null) {
            List cardexes = this.cardexService.getCardexesByCuenta(cuentaID);
            if (cardexes.isEmpty()) {
                this.cuentaService.delete((Serializable)cuentaID);
                this.stop(sw, "DELETE /api/cuenta/cerrarCuenta/{} end corrId={} ok=true timeMs={}", new Object[]{cuentaID, corrId, sw.getTotalTimeMillis()});
                return cuenta;
            }
            this.stop(sw, "DELETE /api/cuenta/cerrarCuenta/{} end corrId={} error=CuentaConProductos timeMs={}", new Object[]{cuentaID, corrId, sw.getTotalTimeMillis()});
            throw new EntityExistsException("La cuenta tiene productos ordenados");
        }
        this.stop(sw, "DELETE /api/cuenta/cerrarCuenta/{} end corrId={} error=CuentaNoAbierta timeMs={}", new Object[]{cuentaID, corrId, sw.getTotalTimeMillis()});
        throw new EntityNotFoundException("La cuenta que desea cerrar no se encuentra abierta");
    }

    @GetMapping(value={"/getTicket/{id}"})
    public TicketInfo getTicket(@PathVariable(value="id") int cuentaID, @RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        StopWatch sw = this.start("GET /api/cuenta/getTicket/{} start corrId={}", new Object[]{cuentaID, corrId});
        TicketInfo ticket = this.cuentaService.getInfoTicket(cuentaID);
        if (ticket != null) {
            this.stop(sw, "GET /api/cuenta/getTicket/{} end corrId={} ok=true timeMs={}", new Object[]{cuentaID, corrId, sw.getTotalTimeMillis()});
            return ticket;
        }
        this.stop(sw, "GET /api/cuenta/getTicket/{} end corrId={} error=CuentaNoExiste timeMs={}", new Object[]{cuentaID, corrId, sw.getTotalTimeMillis()});
        throw new EntityNotFoundException("La cuenta no existe");
    }

    private StopWatch start(String pattern, Object ... args) {
        StopWatch sw = new StopWatch();
        sw.start();
        log.info(pattern, args);
        return sw;
    }

    private void stop(StopWatch sw, String pattern, Object ... args) {
        if (sw.isRunning()) {
            sw.stop();
        }
        log.info(pattern, args);
    }

    private int size(List<?> list) {
        return list == null ? 0 : list.size();
    }

    private int len(String s) {
        return s == null ? 0 : s.length();
    }

    private String clip(String s) {
        if (s == null) {
            return "null";
        }
        return s.length() <= 64 ? s : s.substring(0, 61) + "...";
    }

    private String summarizeOrden(OrdenRequest orden) {
        if (orden == null) {
            return "null";
        }
        try {
            Integer cuentaId = orden.getCuentaId();
            int lineas = orden.getPLUs() == null ? 0 : orden.getPLUs().size();
            return "cuentaId=" + cuentaId + ", items=" + lineas;
        }
        catch (Exception e) {
            return "unavailable";
        }
    }
}

