/*
 * Decompiled with CFR 0.152.
 */
package com.sierra.pdv.endpoint;

import com.sierra.pdv.domain.entity.Cardex;
import com.sierra.pdv.domain.request.CancelacionesRequest;
import com.sierra.pdv.service.CardexService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StopWatch;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cardex"})
public class CardexRest {
    private static final Logger log = LoggerFactory.getLogger(CardexRest.class);
    private final CardexService cardexService;

    public CardexRest(CardexService cardexService) {
        this.cardexService = cardexService;
    }

    @GetMapping(value={"/{cuentaId}"})
    public List<Cardex> getCardexesByAccount(@PathVariable(value="cuentaId") int cuentaId, @RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        StopWatch sw = new StopWatch();
        sw.start();
        log.info("GET /api/cardex/{} start corrId={}", (Object)cuentaId, (Object)corrId);
        List list = this.cardexService.getCardexesByCuenta(Integer.valueOf(cuentaId));
        sw.stop();
        log.info("GET /api/cardex/{} end corrId={} count={} timeMs={}", new Object[]{cuentaId, corrId, list != null ? list.size() : 0, sw.getTotalTimeMillis()});
        return list;
    }

    @PutMapping(value={"/{idCuenta}"})
    public ResponseEntity<Cardex> cancelarPLU(@PathVariable(value="idCuenta") Integer cuentaId, @RequestParam(value="idCardex") int idCardex, @RequestParam(value="emp_can") String emplCan, @RequestParam(value="mot_can") String motivoCan, @RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        StopWatch sw = new StopWatch();
        sw.start();
        log.info("PUT /api/cardex/{} start corrId={} idCardex={} emp_can={} mot_can={}", new Object[]{cuentaId, corrId, idCardex, this.clip(emplCan), this.clip(motivoCan)});
        ResponseEntity resp = this.cardexService.cancelarPLU(cuentaId, idCardex, emplCan, motivoCan);
        sw.stop();
        HttpStatus status = resp != null ? resp.getStatusCode() : HttpStatus.INTERNAL_SERVER_ERROR;
        log.info("PUT /api/cardex/{} end corrId={} status={} timeMs={}", new Object[]{cuentaId, corrId, status.value(), sw.getTotalTimeMillis()});
        return resp;
    }

    @PutMapping(value={"/cancelaciones/{idCuenta}"})
    public List<Cardex> cancelarPLUs(@PathVariable(value="idCuenta") Integer cuentaId, @RequestBody CancelacionesRequest cancelaciones, @RequestHeader(value="X-Correlation-Id", required=false) String corrId) {
        StopWatch sw = new StopWatch();
        sw.start();
        log.info("PUT /api/cardex/cancelaciones/{} start corrId={} payloadSummary={}", new Object[]{cuentaId, corrId, this.summarizeCancelaciones(cancelaciones)});
        List result = this.cardexService.cancelarPLus(cuentaId, cancelaciones);
        sw.stop();
        log.info("PUT /api/cardex/cancelaciones/{} end corrId={} resultCount={} timeMs={}", new Object[]{cuentaId, corrId, result != null ? result.size() : 0, sw.getTotalTimeMillis()});
        return result;
    }

    private String clip(String s) {
        if (s == null) {
            return "null";
        }
        return s.length() <= 64 ? s : s.substring(0, 61) + "...";
    }

    private String summarizeCancelaciones(CancelacionesRequest req) {
        if (req == null) {
            return "null";
        }
        try {
            int count = req.getCancelaciones() == null ? 0 : req.getCancelaciones().size();
            return "items=" + count;
        }
        catch (Exception e) {
            return "unavailable";
        }
    }
}

