/*
 * Decompiled with CFR 0.152.
 */
package com.sierra.pdv.domain.entity;

import com.sierra.pdv.domain.entity.vistas.EmpleadoVista;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="PdvCta")
public class Cuenta {
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Id
    @Column(name="PdvCta_Con")
    private Integer id;
    @Column(name="PdvCta_Hor")
    private String hora;
    @Column(name="PdvCta_Fec", columnDefinition="datetime")
    private String fecha;
    @Column(name="PdvCta_Pos")
    private String pos;
    @Column(name="PdvCta_Cta")
    private String cuenta;
    @Column(name="PdvCta_Per")
    private Integer numPersonas;
    @Column(name="PdvCta_Not")
    private Integer numNotas;
    @Column(name="PdvCta_Abr")
    private String empleadoAbridorNum;
    @Transient
    private EmpleadoVista empleadoAbridor;
    @Column(name="PdvCta_Cla")
    private String tipoCuenta;
    @Column(name="PdvCta_Cli")
    private String cliente;
    @Column(name="PdvCta_Sub", columnDefinition="decimal", precision=18, scale=2)
    private BigDecimal sub;
    @Column(name="PdvCta_Iva", columnDefinition="decimal", precision=18, scale=4)
    private BigDecimal iva;
    @Column(name="PdvCta_Cre", columnDefinition="decimal", precision=18, scale=2)
    private BigDecimal cre;
    @Column(name="PdvCta_Cam", columnDefinition="decimal", precision=18, scale=2)
    private BigDecimal cam;
    @Column(name="PdvCta_Caj")
    private String caja;
    @Column(name="PdvCta_Fol")
    private Integer folio;
    @Column(name="PdvCta_Loc")
    private String locacion;
    @Column(name="PdvCta_Hrc")
    private String hrc;
    @Column(name="PdvCta_Sta")
    private String sta;
    @Column(name="PdvCta_Env")
    private Integer env;
    @Column(name="PdvCta_NomCta")
    private String nombreCuenta;
    @Column(name="PdvCta_NumImp")
    private Integer numeroImpreso;
    @Column(name="PdvCta_TipVxt")
    private String tipVxt;
    @Column(name="PdvCta_StaAbi")
    private String estadoAbierto;
    @Column(name="PdvCta_Pro")
    private String pro;
    @Column(name="PdvCta_91", columnDefinition="decimal", precision=18, scale=2)
    private BigDecimal pago1;
    @Column(name="PdvCta_92", columnDefinition="decimal", precision=18, scale=2)
    private BigDecimal pago2;
    @Column(name="PdvCta_93", columnDefinition="decimal", precision=18, scale=2)
    private BigDecimal pago3;
    @Column(name="PdvCta_94", columnDefinition="decimal", precision=18, scale=2)
    private BigDecimal pago4;
    @Column(name="PdvCta_95", columnDefinition="decimal", precision=18, scale=2)
    private BigDecimal pago5;
    @Column(name="PdvCta_96", columnDefinition="decimal", precision=18, scale=2)
    private BigDecimal pago6;
    @Column(name="PdvCta_97", columnDefinition="decimal", precision=18, scale=2)
    private BigDecimal pago7;
    @Column(name="PdvCta_98", columnDefinition="decimal", precision=18, scale=2)
    private BigDecimal pago8;
    @Column(name="PdvCta_99", columnDefinition="decimal", precision=18, scale=2)
    private BigDecimal pago9;
    @Column(name="PdvCta_FolTxt")
    private String folioTxt;
    @Column(name="PdvCta_Dia")
    private Integer dia;
    @Column(name="PdvCta_Tip")
    private Integer tipo;
    @Column(name="PdvCta_Hom")
    private Integer hom;
    @Column(name="PdvCta_Fwd")
    private String fwd;
    @Column(name="PdvCta_Nota")
    private String nota;
    @Column(name="PdvCta_StaEsEfe")
    private String staEsEfe;
    @Column(name="PdvCta_NumPro")
    private String numPro;
    @Column(name="PdvCta_SubCalc")
    private BigDecimal subCal;
    @Column(name="PdvCta_IvaCalc")
    private BigDecimal ivaCal;
    @Column(name="PdvCta_StaWeb")
    private Integer staWeb;
    @Column(name="PdvCta_DscCalc")
    private BigDecimal descCalc;
    @Column(name="PdvCta_IepsCalc")
    private BigDecimal iepsCalc;

    public static String transformNumCuenta(String numCuenta) {
        if (numCuenta != null && !numCuenta.isEmpty()) {
            if (numCuenta.length() > 6) {
                return null;
            }
            int cerosFaltantes = 6 - numCuenta.length();
            StringBuilder numCuentaReal = new StringBuilder();
            for (int i = 0; i < cerosFaltantes; ++i) {
                numCuentaReal.append('0');
            }
            numCuentaReal.append(numCuenta);
            return numCuentaReal.toString();
        }
        return null;
    }

    public Integer getId() {
        return this.id;
    }

    public String getHora() {
        return this.hora;
    }

    public String getFecha() {
        return this.fecha;
    }

    public String getPos() {
        return this.pos;
    }

    public String getCuenta() {
        return this.cuenta;
    }

    public Integer getNumPersonas() {
        return this.numPersonas;
    }

    public Integer getNumNotas() {
        return this.numNotas;
    }

    public String getEmpleadoAbridorNum() {
        return this.empleadoAbridorNum;
    }

    public EmpleadoVista getEmpleadoAbridor() {
        return this.empleadoAbridor;
    }

    public String getTipoCuenta() {
        return this.tipoCuenta;
    }

    public String getCliente() {
        return this.cliente;
    }

    public BigDecimal getSub() {
        return this.sub;
    }

    public BigDecimal getIva() {
        return this.iva;
    }

    public BigDecimal getCre() {
        return this.cre;
    }

    public BigDecimal getCam() {
        return this.cam;
    }

    public String getCaja() {
        return this.caja;
    }

    public Integer getFolio() {
        return this.folio;
    }

    public String getLocacion() {
        return this.locacion;
    }

    public String getHrc() {
        return this.hrc;
    }

    public String getSta() {
        return this.sta;
    }

    public Integer getEnv() {
        return this.env;
    }

    public String getNombreCuenta() {
        return this.nombreCuenta;
    }

    public Integer getNumeroImpreso() {
        return this.numeroImpreso;
    }

    public String getTipVxt() {
        return this.tipVxt;
    }

    public String getEstadoAbierto() {
        return this.estadoAbierto;
    }

    public String getPro() {
        return this.pro;
    }

    public BigDecimal getPago1() {
        return this.pago1;
    }

    public BigDecimal getPago2() {
        return this.pago2;
    }

    public BigDecimal getPago3() {
        return this.pago3;
    }

    public BigDecimal getPago4() {
        return this.pago4;
    }

    public BigDecimal getPago5() {
        return this.pago5;
    }

    public BigDecimal getPago6() {
        return this.pago6;
    }

    public BigDecimal getPago7() {
        return this.pago7;
    }

    public BigDecimal getPago8() {
        return this.pago8;
    }

    public BigDecimal getPago9() {
        return this.pago9;
    }

    public String getFolioTxt() {
        return this.folioTxt;
    }

    public Integer getDia() {
        return this.dia;
    }

    public Integer getTipo() {
        return this.tipo;
    }

    public Integer getHom() {
        return this.hom;
    }

    public String getFwd() {
        return this.fwd;
    }

    public String getNota() {
        return this.nota;
    }

    public String getStaEsEfe() {
        return this.staEsEfe;
    }

    public String getNumPro() {
        return this.numPro;
    }

    public BigDecimal getSubCal() {
        return this.subCal;
    }

    public BigDecimal getIvaCal() {
        return this.ivaCal;
    }

    public Integer getStaWeb() {
        return this.staWeb;
    }

    public BigDecimal getDescCalc() {
        return this.descCalc;
    }

    public BigDecimal getIepsCalc() {
        return this.iepsCalc;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setHora(String hora) {
        this.hora = hora;
    }

    public void setFecha(String fecha) {
        this.fecha = fecha;
    }

    public void setPos(String pos) {
        this.pos = pos;
    }

    public void setCuenta(String cuenta) {
        this.cuenta = cuenta;
    }

    public void setNumPersonas(Integer numPersonas) {
        this.numPersonas = numPersonas;
    }

    public void setNumNotas(Integer numNotas) {
        this.numNotas = numNotas;
    }

    public void setEmpleadoAbridorNum(String empleadoAbridorNum) {
        this.empleadoAbridorNum = empleadoAbridorNum;
    }

    public void setEmpleadoAbridor(EmpleadoVista empleadoAbridor) {
        this.empleadoAbridor = empleadoAbridor;
    }

    public void setTipoCuenta(String tipoCuenta) {
        this.tipoCuenta = tipoCuenta;
    }

    public void setCliente(String cliente) {
        this.cliente = cliente;
    }

    public void setSub(BigDecimal sub) {
        this.sub = sub;
    }

    public void setIva(BigDecimal iva) {
        this.iva = iva;
    }

    public void setCre(BigDecimal cre) {
        this.cre = cre;
    }

    public void setCam(BigDecimal cam) {
        this.cam = cam;
    }

    public void setCaja(String caja) {
        this.caja = caja;
    }

    public void setFolio(Integer folio) {
        this.folio = folio;
    }

    public void setLocacion(String locacion) {
        this.locacion = locacion;
    }

    public void setHrc(String hrc) {
        this.hrc = hrc;
    }

    public void setSta(String sta) {
        this.sta = sta;
    }

    public void setEnv(Integer env) {
        this.env = env;
    }

    public void setNombreCuenta(String nombreCuenta) {
        this.nombreCuenta = nombreCuenta;
    }

    public void setNumeroImpreso(Integer numeroImpreso) {
        this.numeroImpreso = numeroImpreso;
    }

    public void setTipVxt(String tipVxt) {
        this.tipVxt = tipVxt;
    }

    public void setEstadoAbierto(String estadoAbierto) {
        this.estadoAbierto = estadoAbierto;
    }

    public void setPro(String pro) {
        this.pro = pro;
    }

    public void setPago1(BigDecimal pago1) {
        this.pago1 = pago1;
    }

    public void setPago2(BigDecimal pago2) {
        this.pago2 = pago2;
    }

    public void setPago3(BigDecimal pago3) {
        this.pago3 = pago3;
    }

    public void setPago4(BigDecimal pago4) {
        this.pago4 = pago4;
    }

    public void setPago5(BigDecimal pago5) {
        this.pago5 = pago5;
    }

    public void setPago6(BigDecimal pago6) {
        this.pago6 = pago6;
    }

    public void setPago7(BigDecimal pago7) {
        this.pago7 = pago7;
    }

    public void setPago8(BigDecimal pago8) {
        this.pago8 = pago8;
    }

    public void setPago9(BigDecimal pago9) {
        this.pago9 = pago9;
    }

    public void setFolioTxt(String folioTxt) {
        this.folioTxt = folioTxt;
    }

    public void setDia(Integer dia) {
        this.dia = dia;
    }

    public void setTipo(Integer tipo) {
        this.tipo = tipo;
    }

    public void setHom(Integer hom) {
        this.hom = hom;
    }

    public void setFwd(String fwd) {
        this.fwd = fwd;
    }

    public void setNota(String nota) {
        this.nota = nota;
    }

    public void setStaEsEfe(String staEsEfe) {
        this.staEsEfe = staEsEfe;
    }

    public void setNumPro(String numPro) {
        this.numPro = numPro;
    }

    public void setSubCal(BigDecimal subCal) {
        this.subCal = subCal;
    }

    public void setIvaCal(BigDecimal ivaCal) {
        this.ivaCal = ivaCal;
    }

    public void setStaWeb(Integer staWeb) {
        this.staWeb = staWeb;
    }

    public void setDescCalc(BigDecimal descCalc) {
        this.descCalc = descCalc;
    }

    public void setIepsCalc(BigDecimal iepsCalc) {
        this.iepsCalc = iepsCalc;
    }
}

