/*
 * Decompiled with CFR 0.152.
 */
package com.sierra.pdv.config;

import com.google.firebase.messaging.AndroidConfig;
import com.google.firebase.messaging.AndroidNotification;
import com.google.firebase.messaging.ApnsConfig;
import com.google.firebase.messaging.Aps;
import com.google.firebase.messaging.FirebaseMessaging;
import com.google.firebase.messaging.Message;
import com.google.firebase.messaging.Notification;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sierra.pdv.domain.firebase.NotificationRequest;
import java.time.Duration;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import org.springframework.stereotype.Service;

@Service
public class NotificationService {
    private Logger logger = Logger.getLogger(NotificationService.class.getName());

    public void sendMessageToToken(NotificationRequest request) throws InterruptedException, ExecutionException {
        Message message = this.getPreconfiguredMessageToToken(request);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String jsonOutput = gson.toJson((Object)message);
        String response = this.sendAndGetResponse(message);
        this.logger.info("Sent message to token. Device token: " + request.getToken() + ", " + response + " msg " + jsonOutput);
    }

    private String sendAndGetResponse(Message message) throws InterruptedException, ExecutionException {
        return (String)FirebaseMessaging.getInstance().sendAsync(message).get();
    }

    private AndroidConfig getAndroidConfig(String topic, String sound) {
        return AndroidConfig.builder().setTtl(Duration.ofMinutes(2L).toMillis()).setCollapseKey(topic).setPriority(AndroidConfig.Priority.HIGH).setNotification(AndroidNotification.builder().setTag(topic).setSound(sound).build()).build();
    }

    private ApnsConfig getApnsConfig(String topic) {
        return ApnsConfig.builder().setAps(Aps.builder().setCategory(topic).setThreadId(topic).build()).build();
    }

    private Message getPreconfiguredMessageToToken(NotificationRequest request) {
        return this.getPreconfiguredMessageBuilder(request).setToken(request.getToken()).build();
    }

    private Message.Builder getPreconfiguredMessageBuilder(NotificationRequest request) {
        AndroidConfig androidConfig = this.getAndroidConfig(request.getTopic(), request.getSound());
        ApnsConfig apnsConfig = this.getApnsConfig(request.getTopic());
        Notification notification = Notification.builder().setTitle(request.getTitle()).setBody(request.getBody()).build();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("title", request.getTitle());
        data.put("body", request.getBody());
        data.put("sound", request.getSound());
        data.put("topic", request.getTopic());
        return Message.builder().putAllData(data);
    }
}

